<?php
class Generic_model extends CI_Model{
	function __construct(){
		parent::__construct();
		$this->session_ = $this->session->userdata('userInfo');

		if(!empty($this->session_['database'])){
			$database = $this->session_['database'];
		}else{
			$database = 'default';
		}
		$this->CustomDB=$this->load->database($database, TRUE);

	}
	function save($table,$data,$return = false){
		if($this->CustomDB->insert($table, $data)){
			if($return):
				return $this->CustomDB->insert_id();
			else:
				return true;
			endif;
		}
	}
	
	function savebatch($table,$data){
		if($this->CustomDB->insert_batch($table, $data))
			return true;
	}
	
	function delete($table,$field,$value){
		$this->CustomDB->where($field, $value);
		if($this->CustomDB->delete($table))
			return true;	
	}

    function get($table,$param = '*',$wheres = '',$orders = '',$likes = '', $joins = '',$limits = '',$groups = '',$orlikes=''){
        $this->CustomDB->select($param);
        $this->CustomDB->from($table);
		if($wheres != ''):
			foreach($wheres as $field => $value):
				$this->CustomDB->where($field,$value);
			endforeach;
		endif;
		if($joins != ''):
			foreach($joins as $field => $value):
				$value = explode(',',$value);
				if(isset($value[1])){
					$this->CustomDB->join($field,$value[0],$value[1]);
				}else{
					$this->CustomDB->join($field,$value[0]);
				}
			endforeach;
		endif;
		if($orders != ''):
			foreach($orders as $field => $value):
				$this->CustomDB->order_by($field,$value);
			endforeach;
		endif;
		if($likes != ''):
			foreach($likes as $field => $value):
				$this->CustomDB->like($field,$value);
			endforeach;
		endif;
		if($orlikes != ''):
			foreach($orlikes as $field => $value):
				$this->CustomDB->or_like($field,$value);
			endforeach;
		endif;
		if($limits != ''):
			if(is_array($limits)):
				foreach($limits as $field => $value):
					$this->CustomDB->limit($field,$value);
				endforeach;
			else:
				$this->CustomDB->limit($limits); 
			endif;
			
		endif;
		if($groups != ''):
			$this->CustomDB->group_by($groups); 
		endif;
		
        $query = $this->CustomDB->get();
    
        if($query->num_rows() > 0){
            $result= $query->result();
            return $result;
        }
    }
	
	function update($table,$data,$field,$value){
		$this->CustomDB->where($field, $value);
		
		if($this->CustomDB->update($table, $data))
			return true;
	}
	function _update($table,$data,$where){
		$this->CustomDB->where($where);
		
		if($this->CustomDB->update($table, $data))
			return true;
	}
	function aumentar($table,$where,$value,$field,$cant){
		$this->CustomDB->where($where, $value);
		$this->CustomDB->set($field, $field.'+'.$cant, FALSE);
		$this->CustomDB->update($table);
	}
	function disminuir($table,$where,$value,$field,$cant){
		$this->CustomDB->where($where, $value);
		$this->CustomDB->set($field, $field.'-'.$cant, FALSE);
		$this->CustomDB->update($table);
	}
	function sql_custom($sql){
		$query = $this->CustomDB->query($sql);
        
        if($query->num_rows() > 0){
            $result= $query->result();
            return $result;
        }
	}
}
?>