<?php
	$this->load->library('printer');
	$this->load->library('enletras');
	
	$phpPrinter = new Printer();
	$phpInletters = new EnLetras();
	
	$phpPrinter->resetAcum();
	$acum = 0;
	
	/*Init*/
	$printer = printer_open("EPSON LX-350");

	printer_set_option($printer, PRINTER_MODE, 'RAW');

	printer_start_doc($printer, 'Factura Numero: '.$doc_numero);

	printer_start_page($printer);
	
	/*Body*/
	
	$font = printer_create_font('Arial', 9, 7, PRINTER_FW_THIN, false, false, false, 0);	
	printer_select_font($printer, $font);
	
	/*Ghost*/
	$phpPrinter->printString(strtoupper(utf8_decode(substr(" ",0,24))),2,$printer,$acum,13,11,70);
	$phpPrinter->tabPrinter($acum,85);

	$fecha = explode("-",$fecha);
	$fechadia = explode(" ",$fecha[2]);
	$phpPrinter->printString(strtoupper(utf8_decode(substr($cliente,0,35))),2,$printer,$acum,13,11,195);
	$phpPrinter->printString(strtoupper(utf8_decode(substr($direccion_cliente,0,50))),2,$printer,$acum,13,11,185);
	$phpPrinter->tabPrinter($acum,5);
	$phpPrinter->printString($fecha[1],2,$printer,$acum,13,0,490);
	$phpPrinter->printString($fecha[0],2,$printer,$acum,13,0,520);
	$phpPrinter->printString($fechadia[0],2,$printer,$acum,13,0,550);
	$phpPrinter->tabPrinter($acum,3);
	$phpPrinter->printString(strtoupper(utf8_decode(substr($nrc_cliente,0,20))),2,$printer,$acum,13,11,490);
	$phpPrinter->printString(strtoupper(utf8_decode(substr($nit_cliente,0,20))),2,$printer,$acum,13,11,150);
	$phpPrinter->printString(strtoupper(utf8_decode(substr($giro_cliente,0,20))),2,$printer,$acum,13,0,490);
	$phpPrinter->tabPrinter($acum,5);
	$phpPrinter->printString(strtoupper(utf8_decode(substr($vendedor,0,20))),2,$printer,$acum,13,11,560);
	$phpPrinter->tabPrinter($acum,40);
	/*Body*/
	foreach($productos_normal as $producto){
		$phpPrinter->printString(number_format($producto->cant,1),2,$printer,$acum,9,7,130);
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode(addslashes($producto->desc))),30),2,$printer,$acum,9,0,180);
		$phpPrinter->printString(number_format($producto->costo,2),2,$printer,$acum,9,0,480);
		$phpPrinter->printString(number_format($producto->cant * $producto->costo,2),2,$printer,$acum,9,0,625);
		$phpPrinter->tabPrinter($acum,4);
	}
	
	/*Footer*/
	printer_draw_text($printer,$phpInletters->ValorEnLetras($totales['totalTotal'],""), 160, 415);
	printer_draw_text($printer,"Ref:".$referencia." - Casa Matriz", 160, 425);
	printer_draw_text($printer,number_format($totales['totalGrabadas'],2), 615, 415);
	printer_draw_text($printer,number_format($totales['totalIVA'],2), 615, 430);
	printer_draw_text($printer,number_format($totales['totalIVA'] + $totales['totalGrabadas'],2), 615, 445);
	printer_draw_text($printer,number_format(0.00,2), 615, 460);
	printer_draw_text($printer,number_format(0.00,2), 615, 475);
	printer_draw_text($printer,number_format($totales['totalExento'],2), 615, 490);
	printer_draw_text($printer,number_format($totales['totalNS'],2), 615, 500);
	printer_draw_text($printer,number_format($totales['totalTotal'],2), 615, 515);
	
	printer_delete_font($font);
	
	printer_end_page($printer);

	printer_end_doc($printer);

	printer_close($printer);
?>