<div class="panel blank-panel">
	<div class="panel-heading">
		<div class="panel-options">
			<ul class="nav nav-tabs">
				<li class="active"><a data-toggle="tab" href="#compras">Compras</a></li>
				<li><a data-toggle="tab" href="#devoluciones">Devoluciones</a></li>
				<li><a data-toggle="tab" href="#otras">Otras Entradas</a></li>
				
			</ul>
		</div>
		<div class="panel-body">
			<div class="tab-content">
				<div id="compras" class="tab-pane active">
					<table id="tableCompras" class="table">
						<thead>
							<tr>
								<th>ID</th>
								<th>Referencia</th>
								<th>Fecha</th>
								<th>Proveedor</th>
								<th>Usuario</th>
								<th>Documento</th>
								<th>Numero</th>
								<th>Total</th>
								<th>Folio</th>
								<th>Acciones</th>
							</tr>
						</thead>
						<tbody>
							
						</tbody>
					</table>
				</div>
				<div id="devoluciones" class="tab-pane">
					<table id="entradas-devoluciones-table" class="table">
						<thead>
							<tr>
								<th>Referencia</th>
								<th>Fecha</th>
								<th>Cajero</th>
								<th>Documento</th>
								<th>Numero</th>
								<th>Total</th>
								<th>Acciones</th>
							</tr>
						</thead>
						<tbody>
							
						</tbody>
					</table>
				</div>		
				<div id="otras" class="tab-pane">
					<table id="entradas-otras-table" class="table">
						<thead>
							<tr>
								<th>ID</th>
								<th>Fecha</th>
								<th>Concepto</th>
								<th>Acciones</th>
							</tr>
						</thead>
						<tbody>
							
						</tbody>
					</table>
				</div>	
			 </div>
		</div>
	</div>
</div>
<style>
	.dataTables_filter, .dataTables_info { display: none; }
	.idTableHidden{display:none;}
</style>	
<script>	
	$(document).ready(function() {
		var userString = "<?php if(isset($cajeros)):foreach($cajeros as $cajero):?><option value='<?php echo $cajero->id_usuario;?>'><?php echo $cajero->nombre_usuario;?></option><?php endforeach;endif;?>";
		var tableData = $("#tableCompras").DataTable({
			serverSide: true,
			order: [ 2, 'desc' ],
			dom: '<"filtercustom_boxCompras">lftip',
			ajax: {
				"url": "<?php echo base_url()?>productos/cargar_compras",
				"data": function ( d ) {
					d.search_select = $('#filtercustom_selectcompras').val();
					d.search_text = $('#filtercustom_textcompras').val();
					d.search_select_custom = $('#filtercustom_select_customcompras').val();
				}
			},
			columns:[
				{name:'id',data:0},
				{name:'referencia',data:1},
				{name:'fecha',data:2},
				{name:'proveedor',data:3},
				{name:'usuario',data:4},
				{name:'documento',data:5},
				{name:'numero',data:6},
				{name:'total',data:7},
				{name:'folio',data:8},
				{
					orderable:false,
					className:'text-center',
					data:null,
					defaultContent:'<button class="btn btn-info btn-xs view-item">Ver entrada</button> <button class="btn btn-info btn-xs edit-item">Editar entrada</button>'
				}
			],
			columnDefs: [
				{
					targets: [ 0 ],
					searchable: false,
					className:'idTableHidden'
				}
			],
			language: {
				"emptyTable":     "",
				"lengthMenu": "Mostrar _MENU_ registros por pagina",
				"zeroRecords": "",
				"info": "Pagina _PAGE_ de _PAGES_",
				"infoEmpty": "No hay registros",
				"infoFiltered": "(Ningun resultado encontrado de _MAX_ registros)",
				"search":         "Buscar:",
				"paginate": {
					"first":      "Primero",
					"last":       "Ultimo",
					"next":       "Siguiente",
					"previous":   "Anterior"
				}
			},
		});
	
		$('#tableCompras').on('click','.view-item', function ( e ) {
			var dataClick = $(this);
			Custombox.open({
				target: '<?php echo base_url();?>productos/entradadetalles?transaccion='+dataClick.closest('tr').find("td.idTableHidden").text(),
				effect: 'fadein',
				complete: function(){
					
				},
				close: function(){
					
				}
			});
			e.preventDefault();
		});

		$('#tableCompras').on('click','.edit-item', function ( e ) {
			var dataClick = $(this);
			Custombox.open({
				target: '<?php echo base_url();?>productos/editarentrada?transaccion='+dataClick.closest('tr').find("td.idTableHidden").text(),
				effect: 'fadein',
				complete: function(){
					
				},
				close: function(){
					
				}
			});
			e.preventDefault();
		});
		
		$("div.filtercustom_boxCompras").html("<input id='filtercustom_textcompras' type='text' class='form-control' style='margin-left:10px;height:30px;font-size:12px;width:200px;float:right;' placeholder='Buscar'/><select id='filtercustom_select_customcompras' class='form-control' style='margin-left:10px;display:none;height:30px;font-size:12px;width:200px;float:right;'></select><select id='filtercustom_selectcompras' class='form-control' style='height:30px;font-size:12px;width:200px;float:right;'><option value='4'>Referencia</option><option value='0'>Fecha</option><option value='1'>Proveedor</option><option value='2'>Usuario</option><option value='3'>Documento</option></select>");
		
		$('#filtercustom_selectcompras').on('change',function(){
			switch($('#filtercustom_selectcompras').val()){
				case "4":
					if ( $('#filtercustom_textcompras').is('[readonly]') ){
						$("#filtercustom_textcompras").data('daterangepicker').remove();
					}
					$("#filtercustom_select_customcompras").css('display','none');
					$("#filtercustom_textcompras").css('display','inline-block').prop('readonly','').val('').focus();
				break;
				case "0":
					$("#filtercustom_select_customcompras").css('display','none');	
					getCalendarCompras();
				break;
				case "1":
					if ( $('#filtercustom_textcompras').is('[readonly]') ){
						$("#filtercustom_textcompras").data('daterangepicker').remove();
					}
					$("#filtercustom_select_customcompras").css('display','none');
					$("#filtercustom_textcompras").css('display','inline-block').prop('readonly','').val('').focus();
				break;
				case "2":
					$("#filtercustom_textcompras").css('display','none');
					$('#filtercustom_select_customcompras').find('option').remove().end().css('display','inline-block').append(userString).focus();
				break;
				case "3":
					$("#filtercustom_textcompras").css('display','none');
					$('#filtercustom_select_customcompras').find('option').remove().end().css('display','inline-block').append('<option value="0">CCF</option><option value="1">Factura</option><option value="2">Nota de Envio</option>').focus();
					if ( $('#filtercustom_textcompras').is('[readonly]') ){
						$("#filtercustom_textcompras").data('daterangepicker').remove();
					}
					$("#filtercustom_textcompras").css('display','inline-block').prop('readonly','').val('');
				break;
			}
			tableData.search($('div.dataTables_filter input').val()).draw();
		});
		
		$('#filtercustom_select_customcompras').on('change',function(){
			switch($('#filtercustom_selectcompras').val()){
				case "2":
					tableData.search($('div.dataTables_filter input').val()).draw();
				break;
				case "3":
					tableData.search($('div.dataTables_filter input').val()).draw();
					$("#filtercustom_textcompras").css('display','inline-block').prop('readonly','').val('').focus();
				break;
			}
		});
		
		$('#filtercustom_textcompras').on('keyup change',function(){
			tableData.search($('div.dataTables_filter input').val()).draw();
		});
		
		function getCalendarCompras(){
			$('#filtercustom_textcompras').daterangepicker({
				format: 'YYYY-MM-DD',
				separator: ' al ',
				singleDatePicker: true,
				locale: {
					applyLabel: 'Aplicar',
					cancelLabel: 'Cancelar',
					fromLabel: 'Desde',
					toLabel: 'Hasta',
					weekLabel: 'W',
					customRangeLabel: 'Custom Range',
					daysOfWeek: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi','Sa'],
					monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre']
				},
				showDropdowns: true
			}).prop('readonly','readonly').css('display','inline-block').focus().val('');
		}
		
		
		var tableDevoluciones=$("#entradas-devoluciones-table").DataTable({
			serverSide: true,
			ajax:{
				url:'<?php echo base_url()?>productos/cargar_devoluciones',
				data:function(d){
					d.search['by']=$('#devoluciones-param-select-search').val();
					d.search['doc']=$('#devoluciones-doc-select-search').val();
				}
			},
			dom: 'l<"custom_searchbox_devoluciones">tip',
			order: [ 0, 'desc' ],
			columns:[
				{name:'referencia',data:0},
				{name:'fecha',data:1},
				{name:'cajero',data:2},
				{name:'documento',data:3},
				{name:'numero',data:4},
				{name:'total',data:5,orderable:false},
				{name:'acciones',data:6,orderable:false},
			],
			language: {
				"emptyTable":"",
				"lengthMenu": "Mostrar _MENU_ registros por pagina",
				"zeroRecords":"",
				"info": "Pagina _PAGE_ de _PAGES_ de _MAX_ registros encontrados",
				"infoEmpty":"No hay registros",
				"infoFiltered":"(Ningun resultado encontrado de _MAX_ registros)",
				"search":"Buscar:",
				"paginate": {
					"first":"Primero",
					"last": "Ultimo",
					"next": "Siguiente",
					"previous":"Anterior"
				}
			},
		});
		$("div.custom_searchbox_devoluciones").html("<div class='pull-right m-sm'><label>Buscar:</label> <select class='form-control' id='devoluciones-param-select-search'><option value='referencia' selected>Referencia</option><option value='fecha'>Fecha</option><option value='cajero'>Cajero</option><option value='documento'>Documento</option></select><div id='devoluciones-field-search-wrapper' class='pull-right'><input type='text' id='devoluciones-table-search-field' class='form-control' style='width:250px;' placeholder='Numero de referencia'></div></div><div class='clear-fix'></div>")
		$("#devoluciones-param-select-search").on("change",function(){
			$fieldWrapper=$("#devoluciones-field-search-wrapper");
			$fieldWrapper.html("");
			var $textbox=$("<input type='text' id='devoluciones-textbox-search' class='form-control' style='width:250px;'>");
			var $select=$("<select id='devoluciones-select-search' class='form-control' style='width:250px;'></select>");
			switch($(this).val()){
				case "referencia":
					$textbox.attr("placeholder","Numero de referencia");
					$fieldWrapper.append($textbox);
					$textbox.on("keyup",function(){
						tableDevoluciones.search($(this).val()).draw();
					});
					$textbox.focus();
				break;
				case "fecha":
					$textbox.attr("placeholder","Seleccione una fecha");
					$textbox.attr("readonly","readonly");
					$fieldWrapper.append($textbox);
					$textbox.daterangepicker({
						format: 'DD-MM-YYYY',
						separator: ' al ',
						singleDatePicker: true,
						locale:{
							applyLabel: 'Aplicar',
							cancelLabel: 'Cancelar',
							fromLabel: 'Desde',
							toLabel: 'Hasta',
							weekLabel: 'W',
							customRangeLabel: 'Custom Range',
							daysOfWeek: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi','Sa'],
							monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre']
						},
						showDropdowns: true
					});
					$textbox.on("change",function(){
						tableDevoluciones.search($(this).val()).draw();
					});
					$textbox.focus();
				break;
				case "cajero":
					$select.html("<option disabled selected>Seleccione uno...</option>"
					<?php if(count($cajeros)):foreach($cajeros as $cajero):?>
					+"<option value='<?php echo $cajero->id_usuario;?>'><?php echo $cajero->nombre_usuario;?></option>"
					<?php endforeach;endif;?>
					);
					$fieldWrapper.append($select);
					$select.on("change",function(){
						tableDevoluciones.search($(this).val()).draw();
					});
					$select.focus();
					break;
				case "documento":
					$select.html("<option value='' selected>Todos</option><option value='0'>Ninguno</option><option value='1'>Factura</option><option value='2'>CCF</option><option value='3'>Ticket</option><option value='4'>N. Remisi&oacute;n</option><option value='5'>N. Env&iacute;o</option>")
					$select.attr("style","width:125px;");
					$select.attr("id","devoluciones-doc-select-search");
					$textbox.attr("style","width:125px;");
					$fieldWrapper.append($select);
					$fieldWrapper.append($textbox);
					$select.on("change",function(){
						tableDevoluciones.search('').draw();
						$textbox.val('');
						$textbox.focus();
					});
					$textbox.on("keyup",function(){
						tableDevoluciones.search($(this).val()).draw();
					});
					$select.focus();
					break;
			}
			tableDevoluciones.search('').draw();
		});
		$("#devoluciones-table-search-field").on("keyup",function(){
			tableDevoluciones.search($(this).val()).draw();
		});
		$("#entradas-devoluciones-table").on("click",".devoluciones-table-view-btn",function(e){
				e.preventDefault();
				var id= $(this).attr("data-id");
				Custombox.open({
					target: '<?php echo base_url();?>productos/entradadetalles?transaccion='+id+'&source=devolucion',
					effect: 'fadein'
				});
		});

		
		var tableOtras=$("#entradas-otras-table").DataTable({
			serverSide:true,
			order:[ 2, 'desc' ],
			ajax:{
				"url":"<?php echo base_url()?>productos/cargar_otras",
				"data":function(d){}
			},
			columns:[
				{name:'id',data:0},
				{name:'fecha',data:1},
				{name:'concepto',data:2},
				{
					orderable:false,
					data:null,
					defaultContent:'<button class="btn btn-info btn-xs view-item">Ver entrada</button>'
				}
			],
			columnDefs: [
				{
					targets: [ 0 ],
					searchable: false,
					className:'idTableHidden'
				}
			],
			language: {
				"emptyTable":     "",
				"lengthMenu": "Mostrar _MENU_ registros por pagina",
				"zeroRecords": "",
				"info": "Pagina _PAGE_ de _PAGES_",
				"infoEmpty": "No hay registros",
				"infoFiltered": "(Ningun resultado encontrado de _MAX_ registros)",
				"search":         "Buscar:",
				"paginate": {
					"first":      "Primero",
					"last":       "Ultimo",
					"next":       "Siguiente",
					"previous":   "Anterior"
				}
			},
		});
		
		console.dir(tableOtras);
		
		$('#entradas-otras-table').on('click','.view-item', function ( e ) {
			var dataClick = $(this);
			Custombox.open({
				target: '<?php echo base_url();?>productos/entradadetalles?transaccion='+dataClick.closest('tr').find("td.idTableHidden").text(),
				effect: 'fadein',
				complete: function(){
					
				},
				close: function(){
					
				}
			});
			e.preventDefault();
		});
	});
</script>