<div class="row">
	<div class="col-sm-5"> <!--Linea nueva-->
		<div class="ibox">
			<div class="ibox-title">
				<h5>Nueva linea</h5>
			</div>
			<div class="ibox-content">
				<div class="form-group">
					<div class="row">
						<form id="commentForm">
							<div class="input-group">
								<input id="nuevo-grupo-nombre-txt" type="text" class="form-control" placeholder="Nombre del grupo" required autofocus>
								<span class="input-group-btn"> 
									<button id="crear-grupo-btn" type="button" class="btn btn-info">Crear grupo</button> 
								</span>
							</div>
						</form>
						<input type="hidden" id="nombre-grupo" value="">
					</div>
					<div class="row" id="nuevo-grupo-success" style="display:none;">
						<div class="alert alert-success  m-t-xs m-b-xs p-xxs">
							<i class="fa fa-check-square-o fa-2x"></i>
							&iexcl;Se ha creado el grupo! <span id="nombre-grupo-span"></span> Ahora puede agregar subgrupos a la linea
						</div>
					</div>
				</div>
				<div class="hr-line-dashed m-t-xs"></div>
				<div id="linea-nuevos-subgrupos-wrapper" style="display:none;">
					<ul class="list-group" id="list-subgrupos">
						<!--<li class="list-group-item list-group-subgrupos">
							Laptops
						</li>-->
						<li class="list-group-item">
							<div class="row">
								<div class="col-sm-12">
									<div class="form-group m-n">
										<form id="subgrupoForm">
											<input type="text" class="form-control" id="nombre-subgrupo" placeholder="Nombre de la subcategoria" required>
										</form>
									</div>
								</div>
							</div>
						</li>
					</ul>
					<div class="row">
						<div class="col-sm-12">
							<div class="form-group m-n">
								<button class="btn btn-primary" id="guardar-linea">Guarda linea</button>
								<button class="btn btn-white" id="cancelar-linea">Cancelar</button>
							</div>
						</div>
					</div>
				</div>
			 </div>
		</div>
	</div><!--</Linea nueva-->
	
	<div class="col-sm-7"><!--Lineas-->
		<div class="ibox">
			<div class="ibox-title">
				<h5>Lineas de productos</h5>
			</div>
			<div class="ibox-content">
				<div class="panel-group" id="lineas-wrapper">
					<!--<div class="panel panel-default">
						<div class="panel-heading">
							<h5 class="panel-title">
								<a data-toggle="collapse" data-parent="#lineas-wrapper" href="#collapseOne">Computadoras</a>
							</h5>
						</div>
						<div id="collapseOne" class="panel-collapse collapse">
							<div class="panel-body">
								<ul class="list-group clear-list" style="margin:0px">
									<li class="list-group-item fist-item">
										Laptops 
										<button class="btn btn-xs pull-right"><i class="fa fa-times"></i></button>
										<button class="btn btn-xs pull-right m-r-xs edit-line"><i class="fa fa-pencil"></i></button> 
										<div class="clearfix"></div>
									</li>
									<li class="list-group-item">
										Laptops 
										<button class="btn btn-xs pull-right"><i class="fa fa-times"></i></button>
										<button class="btn btn-xs pull-right m-r-xs"><i class="fa fa-pencil"></i></button> 
										<div class="clearfix"></div>
									</li>
								</ul>
							</div>
						</div>
					</div>
					-->				
				</div>
			</div>
		</div>
	</div><!--/Lineas-->
</div>
<script>
	$(document).ready(function(){
		lineas.setUrl('<?php echo base_url()?>');
		lineas.cargar();
		/*Activar editar grupo*/
		$("#lineas-wrapper").on("click",".panel-default .panel-heading .btn-group .editar-grupo-btn",function(){
			var item=$(this).closest('.panel');
			lineas.editarGrupo(item);
		});
			$("#lineas-wrapper").on("click",".panel-default .panel-heading .cancel-edit-btn",function(){ /*Cancelar editar grupo*/
				var item=$(this).closest('.panel');
				lineas.cancelarEditarGrupo(item);
			});
			$("#lineas-wrapper").on("click",".panel-default .panel-heading .update-linea-btn",function(){/*Actualizar editar grupo*/
				var grupo=$('.editar-grupo-txt');
				if(!$.trim(grupo.val())==''){
					var id=grupo.closest('.panel-heading').attr('data-group-id');
					lineas.actualizarLinea('grupos',grupo,id);
				}else{
					grupo.focus();
					grupo.attr('style','border:solid 1px red !important');
				}
			});
			$("#lineas-wrapper").on("keyup",".panel-default .panel-heading .editar-grupo-txt",function(e){ /*Editar txt keyboard events*/
				if(e.which == 27){
					var item=$(this).closest('.panel');
					lineas.cancelarEditarGrupo(item);
				}else if(e.which == 13){
					$("#lineas-wrapper .panel-default .panel-heading .update-linea-btn").trigger('click');
				}
			});
		/*Activar editar subgrupo*/
		$("#lineas-wrapper").on("click",".panel-default .panel-body ul li .editar-subgrupo-btn",function(){
			var item=$(this).closest('li');
			lineas.editarSubgrupo(item);
		});
			$("#lineas-wrapper").on("click",".panel-default .panel-body ul li .input-group .cancel-edit-subgrupo-btn",function(){ /*Cancelar editar subgrupo*/
				var item=$(this).closest('li');
				lineas.cancelarEditarSubgrupo(item);
			});
			$("#lineas-wrapper").on("click",".panel-default .panel-body ul li .update-subgrupo-btn",function(){/*Actualizar editar subgrupo*/
				var subgrupo=$('.editar-subgrupo-txt');
				if(!$.trim(subgrupo.val())==''){
					var id=subgrupo.closest('li').attr('data-id-subgrupo');
					lineas.actualizarLinea('subgrupos',subgrupo,id);
				}else{
					subgrupo.focus();
					subgrupo.attr('style','border:solid 1px red !important');
				}
			});
			$("#lineas-wrapper").on("keyup",".panel-default .panel-body ul li .editar-subgrupo-txt",function(e){ /*Editar txt keyboard events*/
				if(e.which == 27){
					var item=$(this).closest('li');
					lineas.cancelarEditarSubgrupo(item);
				}else if(e.which == 13){
					$("#lineas-wrapper .panel-default .panel-body ul li .update-subgrupo-btn").trigger('click');
				}
			});
		/*Eliminar linea*/
		$("#lineas-wrapper").on("click",".panel-default .panel-heading .btn-group .eliminar-grupo-btn",function(){
			var item=$(this).closest('.panel');
			lineas.eliminarGrupo(item);
		});
		/*Eliminar subgrupo*/
		$("#lineas-wrapper").on("click",".panel-default .panel-body ul li .eliminar-subgrupo-btn",function(){
			var item=$(this).closest('li');
			lineas.eliminarSubgrupo(item);
		});
		
		/*Nuevo subgrupo*/
		$("#lineas-wrapper").on("click",".panel-default .panel-body ul li.linea-agregar-subgrupo button",function(){
			var item=$(this).closest('li');
			lineas.agregarSubgrupo(item); 
		});
			$("#lineas-wrapper").on("click",".panel-default .panel-body ul li.linea-agregar-subgrupo .input-group .cancel-nuevo-subgrupo-btn",function(){ /*Cancelar nuevo subgrupo*/
				var item=$(this).closest('li');
				lineas.cancelarNuevoSubgrupo(item);
			});
			$("#lineas-wrapper").on("click",".panel-default .panel-body ul li.linea-agregar-subgrupo .input-group .guardar-subgrupo-btn",function(){ /*guardar nuevo subgrupo*/
				var item=$(this).closest('li');
				var subgrupo=item.find('.nuevo-subgrupo-txt');
				if(!$.trim(subgrupo.val())==''){
					var id=item.closest('.panel').find('.panel-heading').attr('data-group-id');
					lineas.guardarNuevoSubgrupo(item,id);
				}else{
					subgrupo.focus();
					subgrupo.attr('style','border:solid 1px red !important');
				}
			});
			$("#lineas-wrapper").on("keyup",".panel-default .panel-body ul li.linea-agregar-subgrupo .input-group .nuevo-subgrupo-txt",function(e){ /*Editar txt keyboard events*/
				if(e.which == 27){
					var item=$(this).closest('li');
					lineas.cancelarNuevoSubgrupo(item);
				}else if(e.which == 13){
					$("#lineas-wrapper .panel-default .panel-body ul li.linea-agregar-subgrupo .input-group .guardar-subgrupo-btn").trigger('click');
				}
			});
			
		/*Nueva linea*/
		$("#crear-grupo-btn").click(function(e){
			var dataOk = true;
			$('#commentForm :input:visible[required="required"]').each(function(){
				if(!this.validity.valid){
					dataOk = false;
					$(this).focus();
					return false;
				}
			});
			
			if(dataOk){
				$("#nombre-grupo").val($("#nuevo-grupo-nombre-txt").val());
				$("#nombre-grupo-span").html("<b>"+$("#nombre-grupo").val()+"</b>");
				$("#nuevo-grupo-success").fadeIn(function(){
					$("#linea-nuevos-subgrupos-wrapper").fadeIn(function(){
						$("#nombre-subgrupo").val("").focus();
					});
					$("#commentForm").fadeOut();
				});
			}
			e.preventDefault();
		});
		
		$("#guardar-linea").click(function(){
			var cadena = [];
			if($(".list-group-subgrupos").length < 1){
				/* toastr.options = {
				  "closeButton": true,
				  "progressBar": true,
				  "positionClass": "toast-top-right"
				}
				toastr.warning('Agregue al menos un SubGrupo a esta Linea');
				$("#nombre-subgrupo").focus(); */
				swal({
					confirmButtonText: 'Si, Guardar',
					cancelButtonText: 'No guardar nada',
					type: 'warning',
					title: 'Sin subgrupo',
					text: 'No ha agregado ningun Subgrupo a esta Linea &iquest;Desea continuar de todos modos?',
					html: true,
					allowOutsideClick: false,
					allowEscapeClick: false,
					showCancelButton: true
				},
				function(isConfirm) {
					if(isConfirm){
						$('.list-group-subgrupos').each(function(index) {
							cadena.push({nombre_subgrupo:$(this).text()});
						});
						$.post('<?php echo base_url();?>productos/guardar_linea', { grupo: $('#nombre-grupo').val(), subgrupos: JSON.stringify(cadena)})
						.done(function() {
							toastr.options = {
							  "closeButton": true,
							  "progressBar": true,
							  "positionClass": "toast-top-right"
							}
							toastr.success('La Linea de Productos se ha agregado exitosamente a la Base de Datos');
							lineas.cargar();
						});
						$("#cancelar-linea").trigger("click");
						setTimeout(function () { $("#cancelar-linea").trigger("click"); }, 100);
					}else{
						setTimeout(function () { $("#nombre-subgrupo").focus(); }, 100);
					}
				});
			}else{
				$('.list-group-subgrupos').each(function(index) {
					cadena.push({nombre_subgrupo:$(this).text()});
				});
				$.post('<?php echo base_url();?>productos/guardar_linea', { grupo: $('#nombre-grupo').val(), subgrupos: JSON.stringify(cadena)})
				.done(function() {
					toastr.options = {
					  "closeButton": true,
					  "progressBar": true,
					  "positionClass": "toast-top-right"
					}
					toastr.success('La Linea de Productos se ha agregado exitosamente a la Base de Datos');
					lineas.cargar();
				});
				$("#cancelar-linea").trigger("click");
			}
		});
		
		$("#cancelar-linea").click(function(){
			$("#commentForm").fadeIn(function(){
				$("#nuevo-grupo-nombre-txt").val("").focus();
				$("#nombre-grupo").val("");
			});
			$("#nombre-grupo-span").html("");
			$("#nuevo-grupo-success,#linea-nuevos-subgrupos-wrapper").fadeOut();
			$(".list-group-subgrupos").remove();
		});
		
		$("#commentForm").on("submit",function(e){
			$("#crear-grupo-btn").trigger("click");
			e.preventDefault();
		});
		
		$("#subgrupoForm").on("submit",function(e){
			$("#list-subgrupos").prepend('<li class="list-group-item list-group-subgrupos">'+$("#nombre-subgrupo").val()+'  <button class="btn btn-xs pull-right eliminar-subgrupo-nlinea-btn"><i class="fa fa-times"></i></button></li>');
			$("#nombre-subgrupo").val("").focus();
			e.preventDefault();
		});
		
		$("#list-subgrupos").on("click",".list-group-subgrupos .eliminar-subgrupo-nlinea-btn",function(){
			$(this).parent().remove();
			$("#nombre-subgrupo").val("").focus();
		});
	});
</script>