<div class="panel blank-panel" id="<?php $winId = date('YmdHis'); echo $winId;?>">
	<div class="panel-heading">
		<div class="panel-options">
			<ul class="nav nav-tabs">
				<li class="active"><a data-toggle="tab" href="#ventas">Ventas</a></li>
				<li><a data-toggle="tab" href="#traslados">Traslados</a></li>
				<li><a data-toggle="tab" href="#otras">Otras Salidas</a></li>				
			</ul>
		</div>
		<div class="panel-body">
			<div class="tab-content">
				<div id="ventas" class="tab-pane active">
					<table id="salidas-ventas-tabla" class="table table-striped">
						<thead>
							<tr>
								<th>Referencia</th>
								<th>Fecha</th>
								<th>Vendedor</th>
								<th>Cliente</th>
								<th>Documento</th>
								<th>Numero</th>
								<th>Total</th>
								<th>Estado</th>
								<th>Acciones</th>
							</tr>
						</thead>
						<tbody></tbody>
					</table>
				</div>
				<div id="traslados" class="tab-pane">
					<table id="salidas-traslados-tabla" class="table table-striped">
						<thead>
							<tr>
								<th>Fecha</th>
								<th>Usuario</th>
								<th>Destino</th>
								<th></th>
							</tr>
						</thead>
						<tbody></tbody>
					</table>
				</div>
				<div id="otras" class="tab-pane">
					<table id="salidas-otras-tabla" class="table">
						<thead>
							<tr>
								<th>Fecha</th>
								<th>Transacci&oacute;n</th>
								<th>Acciones</th>
							</tr>
						</thead>
						<tbody>
							
						</tbody>
					</table>
				</div>	
			 </div>
		</div>
	</div>
</div>
<script>	
	
	class Productos_salidas_agrupadas{
		constructor(url, winId){
			this.baseUrl = url;
			this.windowId = winId;

			this.tableVentas = null;
			this.trasladosTable = null;
			this.tableOtrasSalidas = null;

			this.initializeUI();
			this.initializeListeners();
		}
		initializeUI(){
			let _this = this;
			/**--------- DATATABLES ---------*/
			/**lenguaje */
			let datatablesLanguage = {
				"info": "Mostrando _START_ a _END_ de _TOTAL_ registros",
				"processing": "Procesando...",
				"lengthMenu": "Mostrar _MENU_ registros",
				"zeroRecords": "No se encontraron resultados",
				"emptyTable": "Ningún dato disponible en esta tabla",
				"infoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
				"infoFiltered": "(filtrado de un total de _MAX_ registros)",
				"search": "Buscar:",
				"infoThousands": ",",
				"loadingRecords": "Cargando...",
				"paginate": {
					"first": "Primero",
					"last": "Último",
					"next": "Siguiente",
					"previous": "Anterior"
				}
			};
			/**Ventas datatables */
			this.tableVentas= $("#"+this.windowId+" #salidas-ventas-tabla").DataTable({
				serverSide: true,
				ajax:{
					url: _this.baseUrl + "productos/cargar_ventas",
					data:function(d){
						d.search['by']=$('#ventas-param-select-search').val();
						d.search['doc']=$('#ventas-doc-select-search').val();
					}
				},
				dom: 'l<"custom_searchbox_ventas">tip',
				order: [ 0, 'desc' ],
				columns:[
					{name:'referencia',data:0},
					{name:'fecha',data:1},
					{name:'vendedor',data:2},
					{name:'cliente',data:3},
					{name:'documento',data:4},
					{name:'numero',data:5},
					{name:'total',data:6,orderable:false},
					{name:'estado',data:7},
					{name:'acciones',data:8,orderable:false},
				],
				language: datatablesLanguage
			});
			$("div.custom_searchbox_ventas").html("<div class='pull-right m-sm'><label>Buscar:</label> <select class='form-control' id='ventas-param-select-search'><option value='referencia' selected>Referencia</option><option value='fecha'>Fecha</option><option value='vendedor'>Vendedor</option><option value='cliente'>Cliente</option><option value='documento'>Documento</option></select><div id='ventas-field-search-wrapper' class='pull-right'><input type='text' id='ventas-table-search-field' class='form-control' style='width:250px;' placeholder='Numero de referencia'></div></div><div class='clear-fix'></div>")
			/**Traslados datatables */
			this.trasladosTable = $("#"+this.windowId+" #salidas-traslados-tabla").DataTable({
				serverSide: true,
				ajax: {
					url: _this.baseUrl + "productos/cargar_traslados",
					type: "GET"
				},
				columns: [
					{name: 'fecha', data: 'fecha'}, 
					{name: 'usuario', data: 'usuario'}, 
					{name: 'destino', data: 'destino'},
					{name: 'buttons'}
				],
				columnDefs: [
					{targets: -1, orderable: false, searchable: false, defaultContent: "<button class='btn btn-xs btn-primary salidas-traslados-ver-btn'>Ver traslado</button>"}
				],
				language: datatablesLanguage
			});
			/**Otras salidas datatables */
			this.tableOtrasSalidas=$("#"+this.windowId+" #salidas-otras-tabla").DataTable({
				serverSide: true,
				ajax:{
					url: _this.baseUrl + "productos/cargar_salidas",
				},
				order: [ 0, 'desc' ],
				columns:[
					{name:'fecha',data:0},
					{name:'transaccion',data:1,orderable:false},
					{name:'acciones',data:2,orderable:false,width:"15%"},
				],
				language: datatablesLanguage
			});
		}
		initializeListeners(){
			let _this = this;
			/**--------------- DATATABLES Ventas ---------------*/
			/** (SELECT) Seleccionar un parametro de busqueda (CLICK)*/
			$("#"+this.windowId+" #ventas-param-select-search").on("change",function(){
				let $fieldWrapper=$("#ventas-field-search-wrapper");
				$fieldWrapper.html("");
				let $textbox=$("<input type='text' id='ventas-textbox-search' class='form-control' style='width:250px;'>");
				let $select=$("<select id='ventas-select-search' class='form-control' style='width:250px;'></select>");
				switch($(this).val()){
					case "referencia":
						$textbox.attr("placeholder","Numero de referencia");
						$fieldWrapper.append($textbox);
						$textbox.on("keyup",function(){
							_this.tableVentas.search($(this).val()).draw();
						});
						$textbox.focus();
					break;
					case "fecha":
						$textbox.attr("placeholder","Seleccione una fecha");
						$textbox.attr("readonly","readonly");
						$fieldWrapper.append($textbox);
						$textbox.daterangepicker({
							format: 'DD-MM-YYYY',
							separator: ' al ',
							singleDatePicker: true,
							locale:{
								applyLabel: 'Aplicar',
								cancelLabel: 'Cancelar',
								fromLabel: 'Desde',
								toLabel: 'Hasta',
								weekLabel: 'W',
								customRangeLabel: 'Custom Range',
								daysOfWeek: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi','Sa'],
								monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre']
							},
							showDropdowns: true
						});
						$textbox.on("change",function(){
							_this.tableVentas.search($(this).val()).draw();
						});
						$textbox.focus();
					break;
					case "vendedor":
						$select.html("<option disabled selected>Seleccione uno...</option>"
						<?php if(count($vendedores)):foreach($vendedores as $vendedor):?>
						+"<option value='<?php echo $vendedor->id_usuario;?>'><?php echo $vendedor->nombre_usuario;?></option>"
						<?php endforeach;endif;?>
						);
						$fieldWrapper.append($select);
						$select.on("change",function(){
							_this.tableVentas.search($(this).val()).draw();
						});
						$select.focus();
					break;
					case "cliente":
						$textbox.attr("placeholder","Nombre del cliente");
						$fieldWrapper.append($textbox);
						$textbox.on("keyup",function(){
							_this.tableVentas.search($(this).val()).draw();
						});
						$textbox.focus();
					break;
					case "documento":
						$select.html("<option value='' selected>Todos</option><option value='1'>Factura</option><option value='2'>CCF</option><option value='3'>Ticket</option><option value='4'>N. Remisi&oacute;n</option><option value='5'>N. Env&iacute;o</option>")
						$select.attr("style","width:125px;");
						$select.attr("id","ventas-doc-select-search");
						$textbox.attr("style","width:125px;");
						$fieldWrapper.append($select);
						$fieldWrapper.append($textbox);
						$select.on("change",function(){
							_this.tableVentas.search('').draw();
							$textbox.val('');
							$textbox.focus();
						});
						$textbox.on("keyup",function(){
							_this.tableVentas.search($(this).val()).draw();
						});
						$select.focus();
					break;
				}
				_this.tableVentas.search('').draw();
			});
			/**TEXTBOX Buscar escribiendo parametro (KEYUP)*/
			$("#"+this.windowId+" #ventas-table-search-field").on("keyup",function(){
				_this.tableVentas.search($(this).val()).draw();
			});
			/**BUTTON abri modal de detalles de una venta (CLICK)*/
			$("#"+this.windowId+" #salidas-ventas-tabla").on("click",".ventas-table-view-btn",function(e){
				e.preventDefault();
				var id= $(this).attr("data-id");
				Custombox.open({
					target: _this.baseUrl+'productos/salidadetalles?transaccion='+id+'&source=venta',
					effect: 'fadein'
				});
			});
			/**BUTTON Abrir modal para editar detalles de venta*/
			$("#"+this.windowId+" #salidas-ventas-tabla").on("click",".ventas-table-edit-btn",function(e){
				e.preventDefault();
				var id= $(this).attr("data-id");
				Custombox.open({
					target: _this.baseUrl+'productos/editarsalida?transaccion='+id+'&source=venta',
					effect: 'fadein'
				});
			});
			/**------------- DATATABLES Traslados -------------*/
			$("#"+this.windowId+" #salidas-traslados-tabla").on("click",".salidas-traslados-ver-btn",function(e){
				let id = $(this).closest('tr').attr('id').split('-')[1];
				Custombox.open({
					target: _this.baseUrl+'productos/vertraslado?id='+id,
					effect: 'fadein'
				});
			});
			/**----------- DATATABLES Otras salidas -----------*/
			/**BUTTON Abrir modal para detalles de otras ventas */
			$("#"+this.windowId+" #salidas-otras-tabla").on("click",".salidas-table-view-btn",function(e){
				e.preventDefault();
				let id= $(this).attr("data-id");
				Custombox.open({
					target: _this.baseUrl+'productos/salidadetalles?transaccion='+id,
					effect: 'fadein'
				});
			});
		}
	}
	/**------------- */
	$(document).ready(function(){
		let productos_salidas_agrupadas = new Productos_salidas_agrupadas('<?php echo base_url();?>', '<?php echo $winId;?>');
	});
</script>