<div id="<?php $winId = date('YmdHis'); echo $winId;?>">
	<input type="hidden" id="multiple-salida-transaccion-tipo" value="<?php echo $transaccion;?>">
	<?php if(!isset($salida)):?>
	<?php if($transaccion && $transaccion == 8): /*Traslados*/?>
	<div class="row">
		<label class="col-sm-2 text-right">Destino:</label>
		<div class="col-sm-10">
			<input type="text" name="" id="multiple-salida-transaccion-destino" class="form-control">
		</div>
	</div>
	<div class="row m-t-sm">
		<!--Comentario-->
		<label class="col-sm-2 text-right">Comentario:</label>
		<div class="col-sm-10">
			<input type="text" name="" id="multiple-salida-transaccion-comentario" class="form-control" placeholder="">
		</div>
	</div>
	<?php endif;?>
	<?php if($transaccion && $transaccion == 6): /*Facturacion diferida*/?>
	<div class="row">
		<!--Documento-->
		<label class="col-sm-2 text-right">Documento:</label>
		<div class="col-sm-4">
			<select name="" id="multiple-salida-documento-tipo" class="form-control">
				<option value="" selected="selected" disabled>Seleccione uno...</option>
				<option value="1">Factura</option>
				<option value="2">CCF</option>
				<option value="7">Orden de pedido</option>
			</select>
		</div>
		<div class="col-sm-2">
			<input type="text" name="" id="multiple-salida-documento-numero" class="form-control" placeholder="Numero">
		</div>
		<!--Fecha-->
		<label class="col-sm-1 text-right">Fecha:</label>
		<div class="col-sm-3">
			<div class="input-group">
			<input type="text" name="" id="multiple-salida-documento-fecha" class="form-control" placeholder="" readonly="true" value="<?php echo gmdate("Y-m-d", strtotime("- 6 hours"));?>">
				<span class="input-group-addon">
					<i class="fa fa-calendar"></i>
				</span>
			</div>
		</div>
	</div>
	<div class="row m-t-sm">
		<!--Comentario-->
		<label class="col-sm-2 text-right">Comentario:</label>
		<div class="col-sm-10">
			<input type="text" name="" id="multiple-salida-transaccion-comentario" class="form-control" placeholder="">
		</div>
	</div>
	<?php endif;?>

	<hr>
	<div class="form-group" id="multiple-salida-producto-info">
		<div class="col-sm-2">
			<label>SKU</label>
			<div class="input-group">
				<input type="text"  id="multiple-salida-producto-sku" class="form-control frame-control frame-producto-sku">
				<input type="hidden" id="multiple-salida-producto-id" class="frame-control frame-producto-id">
				<input type="hidden" id="multiple-salida-presentacion-id" class="frame-control frame-presentacion-id">
				<input type="hidden" id="multiple-salida-unidades-representativas" class="frame-control frame-unidades-representativas">
				<span class="input-group-btn">
					<button type="button" id="multiple-salida-producto-buscar" class="btn btn-primary"><i class="fa fa-search"></i></button>
				</span>
			</div>
		</div>
		<div class="col-sm-4">
			<label>Descripci&oacute;n</label>
			<input type="text" id="multiple-salida-producto-desc" class="form-control frame-control frame-producto-desc" readonly>
		</div>
		<div class="col-sm-2">
			<label>Cantidad</label>
			<input type="text" id="multiple-salida-producto-cant" class="form-control frame-control frame-producto-cant">
		</div>
		<div class="col-sm-2">
			<!--<label>Precio</label>
			<input type="text" id="multiple-salida-producto-costo" class="form-control frame-control frame-producto-costo-ultimo">-->
			<label>Precio</label><small class="frame-producto-price-indicator"></small>
			<div class="input-group date">
				<span class="input-group-addon price-navigation-btn" data-role="previus" style="padding:6px 3px;" id="multiple-salida-precio-previo-btn"> <i class="fa fa-chevron-left"></i></span>
				<input type="text" id="multiple-salida-producto-costo" data-active-price='0' class="form-control frame-control frame-producto-precio" data-valid-type="number">
				<span class="input-group-addon price-navigation-btn" data-role="next" style="padding:6px 3px;" id="multiple-salida-precio-siguente-btn"><i class="fa fa-chevron-right"></i></span>
			</div>
			<input type="hidden" id="multiple-salida-producto-precios" class="frame-control frame-producto-precios">
			<input type="hidden" id="multiple-salida-producto-precio-bajo" class="frame-control frame-producto-precio-bajo">
		</div>
		<div class="col-sm-2">
			<button type="button" id="multiple-salida-producto-agregar" class="btn btn-info btn-md m-t-md frame-producto-add-btn">Agregar</button>
		</div>
	</div>
	<?php endif;?>
	<!--table header-->
	<div class="row">
		<table class="table table-hover" style="margin:0px;">
			<thead>
				<tr>
					<th style="width:15%">SKU</th>
					<th style="width:45%">Nombre</th>
					<th style="width:10%">Cant.</th>
					<th style="width:10%">Costo.</th>
					<th style="width:10%">Total.</th>
					<th style="width:10%">Quitar</th>
				</tr>
			</thead>
		</table>
	</div>
	<!-- tabla body-->
	<div class="row">
		<div id="multiple-salida-productos-wrapper">
			<table class="table table-hover" id="multiple-salida-productos-table">
				<tbody>
				<?php if(isset($salida)):if(count($productos)>0):foreach($productos as $producto):?>
					<tr>
						<td class='table-sku' data-value='<?php echo $producto->sku;?>'><?php echo $producto->sku;?></td>
						<td class='table-desc' data-value='<?php echo $producto->desc;?>'><?php echo $producto->desc;?></td>
						<td class='table-cant' data-value='<?php echo $producto->cant;?>'><?php echo $producto->cant;?></td>
						<td class='table-costo' data-value='<?php echo $producto->costo;?>'><?php echo $producto->costo;?></td>
						<td class='table-total' data-value='<?php echo $producto->cant*$producto->costo;?>'><?php echo $producto->cant*$producto->costo;?></td>
						<td class='table-del'></td>
					</tr>
				<?php endforeach;endif;endif;?>
				</tbody>
			</table>
		</div>
	</div>
	<!--totales-->
	<div class="row">
		<div class="col-sm-8">
			<h3 class="m-lg transacction-item-counter">Items en la salida: <b>0</b></h3>
		</div>
		<div class="col-sm-4">
			<table class="table" id="multiple-salida-totales-wrapper">
				<tbody>			
				</tbody>
			</table>
		</div>
	</div>
	<!--totales-->
	<?php if(!isset($salida)):?>
	<div class="form-group" style="margin:0; text-align:center;">
		<button type="button" class="btn btn-danger btn-rounded" onclick="Custombox.close();">Cancelar</button>
		<button type="button" class="btn btn-primary btn-rounded" id="guardar-multiple-salida-btn">Registrar salida</button>
	</div>
</div>
<?php endif;?>
<script>
	class Productos_salidas_nueva_multiple_view{
		constructor(url, winId){
			this.baseUrl = url;
		    this.windowId = winId;
			/** */
			this.toolsMultiple = new Transaccionestools(this.baseUrl);
			this.toolsMultiple.setProductFrame($("#multiple-salida-producto-info"));
			this.toolsMultiple.setProductTable($("#multiple-salida-productos-wrapper > table"));
			this.toolsMultiple.setTotalTable($("#multiple-salida-totales-wrapper"));
			this.toolsMultiple.SetTotalsProfile('sumas,total','sumas',true);

			this.initializeUI();
			this.initializeListeners()
		}
		initializeUI(){
            let _this = this;
			/**Slim scroll */
			$('#'+this.windowId+' #multiple-salida-productos-wrapper').slimScroll({
				height: '200px'
			});
			/**Focus*/
			let trans_tipo = parseInt($('#'+this.windowId+' #multiple-salida-transaccion-tipo').val());
			switch(trans_tipo){
				case 6: /**Facturacion diferida */
					$('#'+_this.windowId+' #multiple-salida-documento-tipo').focus(); 
				break;
				case 8: /**Traslado */
					$('#'+_this.windowId+' #multiple-salida-transaccion-destino').focus();
				break;
			}
			/**Fecha */
			if($('#'+this.windowId+' #multiple-salida-documento-fecha')){
				$('#'+this.windowId+' #multiple-salida-documento-fecha').datepicker({
					language:'es',
					format:'yyyy-mm-dd',
					autoclose:true
				}).on('changeDate',function(ev){
					$('#'+_this.windowId+' #multiple-salida-transaccion-comentario').focus();
				});
			}
		}
		initializeListeners(){
			let _this = this;
			/**--------- Facturacion diferida ---------*/
			/** SELECT seleccionar un documento (Change)  */
			if($('#'+this.windowId+' #multiple-salida-documento-tipo')){
				$('#'+this.windowId+' #multiple-salida-documento-tipo').change(function(){
					$('#'+_this.windowId+' #multiple-salida-documento-numero').focus();
				});
			}
			/** TEXTBOX numero - cambiar foco al presionar enter (KEYPRESS)  */
			if($('#'+this.windowId+' #multiple-salida-documento-numero')){
				$('#'+this.windowId+' #multiple-salida-documento-numero').keypress(function(e){
					if(e.which == 13) {
						$('#'+_this.windowId+' #multiple-salida-documento-fecha').focus();
					}
				});
			}
			/**------------- Traslados -------------*/
			/** TEXTBOX destino - cambiar foco al presionar enter (KEYPRESS)  */
			if($('#'+this.windowId+' #multiple-salida-transaccion-destino')){
				$('#'+this.windowId+' #multiple-salida-transaccion-destino').keypress(function(e){
					if(e.which == 13) {
						$('#'+_this.windowId+' #multiple-salida-transaccion-comentario').focus();
					}
				});
			}
			/** TEXTBOX comentario - cambiar foco al presionar enter (KEYPRESS)  */
			if($('#'+this.windowId+' #multiple-salida-transaccion-comentario')){
				$('#'+this.windowId+' #multiple-salida-transaccion-comentario').keypress(function(e){
					if(e.which == 13) {
						$('#'+_this.windowId+' #multiple-salida-producto-sku').focus();
					}
				});
			}
			/**------------- Agregar producto -------------*/
			/** BUTTON Buscar un producto (CLICK)*/
			$('#'+this.windowId+' #multiple-salida-producto-buscar').click(function(e){
				e.preventDefault();
				Custombox.open({
					target:_this.baseUrl+'productos/buscarproductos?field=multiple-salida-producto-sku&enter=true', 
					effect: 'fadein',
				});
			});
			/**TEXTBOX Presionar enter para cargar SKU (KEYPRESS: ENTER) */
			$("#"+this.windowId+" #multiple-salida-producto-sku").keypress(function(e) {
				if(e.which == 13) {
					e.preventDefault();
					//_this.toolsMultiple.getProductInfoBySKU('descripcion,costo_ultimo',$(this).val(),$("#multiple-salida-producto-cant"));
					_this.toolsMultiple.getProductInfoBySKU('descripcion,precios',$(this).val(),$("#multiple-salida-producto-cant"));
				}
			});
			/**TEXTBOX cantidad - cambiar foco a costo (KEYPRESS: ENTER) */
			$("#"+this.windowId+" #multiple-salida-producto-cant").keypress(function(e) {
				if(e.which == 13) {
					e.preventDefault();
					$("#"+_this.windowId+" #multiple-salida-producto-costo").focus();
				}
			});
			/**TEXTBOX costo - agregar producto (KEYPRESS: ENTER) */
			$("#"+this.windowId+" #multiple-salida-producto-costo").keypress(function(e) {
				if(e.which == 13) {
					e.preventDefault();
					$("#"+_this.windowId+" #multiple-salida-producto-agregar").trigger("click");
				}
			});
			/*Boton navegar precios*/
			$("#"+this.windowId+" .price-navigation-btn").click(function(){
				_this.toolsMultiple.pricesNavigation($(this).attr('data-role'));
			});
			/**BUTTON Agregar productos a la tabla (CLICK) */
			$("#"+this.windowId+" #multiple-salida-producto-agregar").click(function(e){
				_this.toolsMultiple.addProductToTable('data:.frame-producto-id@data-id,data:.frame-presentacion-id@data-pre,data:.frame-unidades-representativas@data-uequiv,field:.frame-producto-sku@table-sku,field:.frame-producto-desc@table-desc,field:.frame-producto-cant@table-cant,field:.frame-producto-precio@table-costo,operation:.frame-producto-cant|*|.frame-producto-precio@table-total,command:remove@table-del');
			});
			/**BUTTON Quitar productos de la tabla (CLICK) */
			$("#"+this.windowId+" #multiple-salida-productos-wrapper").on('click','table tr td.table-del',function(){
				var tr = $(this).closest('tr');
				_this.toolsMultiple.removeProductToTable($(tr));
			});
			/**BUTTON Guardar salida */
			$("#"+this.windowId+" #guardar-multiple-salida-btn").click(function(){
				var $sender = $(this);	
				$sender.attr('disabled','disabled');
				if($("#"+_this.windowId+" #multiple-salida-productos-table tbody tr").length == 0){
					_this.showMsg('error', 'No has agregado ningun Producto, agregue al menos 1');
					$sender.removeAttr('disabled');
				}else{
					let transaccion=$("#salida-nueva-transaccion-tipo option:selected").text();
					swal({
						title: 'Guardar Transacci&oacute;n ',
						text: 'Este proceso es irreversible<br>&iquest;Deseas guardar la salida de '+$("#multiple-salida-productos-table tbody tr").size()+' items como '+transaccion+'?',
						html: true,
						type: 'info',
						showCancelButton: true,
						confirmButtonColor: '#3C8DBC',
						confirmButtonText: 'Si, guardar salida',
						cancelButtonText: 'No guardar nada'
					},
					function(isConfirm){
						if(isConfirm){
							let productos=[];
							let products = $("#"+_this.windowId+" #multiple-salida-productos-table tr");
							$.each(products,function(index,product){
								productos.push({id:$(product).attr('data-id'),pre:$(product).attr('data-pre'),uequiv:$(product).attr('data-uequiv'),desc:$(product).find('.table-desc').attr('data-value'),cant:$(product).find('.table-cant').attr('data-value'),costo:$(product).find('.table-costo').attr('data-value'),tipoventa:$(product).find('.table-tipoventa').attr('data-value')});
							});
							let trans_tipo = parseInt($('#'+_this.windowId+' #multiple-salida-transaccion-tipo').val());
							let data = {
								salida: $("#"+_this.windowId+" #multiple-salida-transaccion-tipo").val(),
								productos:JSON.stringify(productos),
								destino: ($("#"+_this.windowId+" #multiple-salida-transaccion-destino") ? $("#"+_this.windowId+" #multiple-salida-transaccion-destino").val() : ""),
								documento: ($('#'+_this.windowId+' #multiple-salida-documento-tipo') ? $('#'+_this.windowId+' #multiple-salida-documento-tipo').val() : ""),
								docnum: ($('#'+_this.windowId+' #multiple-salida-documento-numero') ? $('#'+_this.windowId+' #multiple-salida-documento-numero').val() : ""),
								fecha: ($('#'+_this.windowId+' #multiple-salida-documento-fecha') ? $('#'+_this.windowId+' #multiple-salida-documento-fecha').val() : ""),
								coment: ($("#"+_this.windowId+" #multiple-salida-transaccion-comentario") ? $("#"+_this.windowId+" #multiple-salida-transaccion-comentario").val() : "")
								
							}
							$.post(_this.baseUrl+'productos/guardarsalida',data).done(function(responseText){
								_this.showMsg('success', 'La salida se ha registrado en la Base de Datos del Sistema');
								/** */
								if($("#salidas-traslados-tabla") && trans_tipo == 8) /** */
									$("#salidas-traslados-tabla").DataTable().ajax.reload();
								else if($("#salidas-otras-tabla") && trans_tipo == 6)
									$("#salidas-otras-tabla").DataTable().ajax.reload();
								/** */
								Custombox.close();
							});
						}else{
							$sender.removeAttr('disabled');
						}
					});
				}
			});
		}
		/*Mostar mensaje*/
		showMsg(tipo, mensaje){
			toastr.options = {
				"closeButton": true,
				"progressBar": true,
				"positionClass": "toast-top-right"
			}
			toastr[tipo](mensaje);
		}
	}
	/**-------------------------------------------- */
	$(document).ready(function() {
        let productos_salidas_nueva_multiple_view = new Productos_salidas_nueva_multiple_view('<?php echo base_url();?>', '<?php echo $winId;?>');
    });
</script>