<div id="<?php $winId = date('YmdHis'); echo $winId;?>">
    <div class="ibox">
        <div class="ibox-title">
            <h5>Informaci&oacute;n del traslado</h5>
        </div>
        <div class="ibox-content">
            <?php if(isset($traslado)):?>
            <!--Informacion-->
            <div class="row">
                <!--Fecha-->
                <div class="col-sm-3">
                    <label class="control-label">Fecha:</label><br>
                    <span><?php echo date("d-m-Y H:m:s", strtotime($traslado->registro_transaccion));?></span>
                </div>
                <!--Usuario-->
                <div class="col-sm-3">
                    <label class="control-label">Usuario:</label><br>
                    <span><?php echo $traslado->nombre_usuario;?></span>
                </div>
                <!--Destino-->
                <div class="col-sm-3">
                    <label class="control-label">Destino:</label><br>
                    <span><?php echo $traslado->comentario2_transaccion;?></span>
                </div>
                <!--Comentario-->
                <div class="col-sm-3">
                    <label class="control-label">Comentario:</label><br>
                    <span><?php echo $traslado->comentario1_transaccion;?></span>
                </div>
            </div>
            <hr>
            <!--Tabla de productos-->
            <div style="height:250px; overflow-y:scroll;">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>sku</th>
                            <th>descripci&oacute;n</th>
                            <th>Cantidad</th>
                            <th>Precio</th>
                            <th>Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if($productos && count($productos)): foreach($productos as $producto):?>
                        <tr>
                            <td><?php echo $producto->sku;?></td>
                            <td><?php echo $producto->desc;?></td>
                            <td><?php echo $producto->cant;?></td>
                            <td><?php echo $producto->costo;?></td>
                            <td><?php echo number_format($producto->cant * $producto->costo, 2);?></td>
                        </tr>
                        <?php endforeach; endif;?>
                    </tbody>
                </table>
            </div>
            <hr>
            <!--Botones-->
            <div class="text-center">
                <button class="btn btn-danger" id="salidas-traslados-detalles-salir-btn">Salir</button>
                <button class="btn btn-primary" id="salidas-traslados-detalles-exportar-btn" data-id="<?php echo $traslado->id_transaccion;?>">Exportar PDF</button>
            </div>
            <?php endif;?>
        </div>
    </div>
</div>
<script>
<?php if(isset($traslado)):?>
    class Productos_salidas_traslados_detalles{
        constructor(url, winId){
			this.baseUrl = url;
			this.windowId = winId;

            this.initializeUI();
			this.initializeListeners();
        }
        initializeUI(){
			let _this = this;
        }
        initializeListeners(){
			let _this = this;
            /**BUTTON Cerrar modal (CLICK)*/
            $("#"+this.windowId+" #salidas-traslados-detalles-salir-btn").click(function(){
                Custombox.close();
            });
            /**BUTTON Exportar (CLICK)*/
            $("#"+this.windowId+" #salidas-traslados-detalles-exportar-btn").click(function(){
                let id = $(this).attr("data-id");
                window.open(_this.baseUrl+"productos/export_traslado_pdf?id="+id);
            });
        }
    }
    /** */
    let productos_salidas_traslados_detalles = new Productos_salidas_traslados_detalles('<?php echo base_url();?>', '<?php echo $winId;?>');
<?php endif;?>
</script>