<div id="grafico-comprasproveedor-container"></div>
<script>
$(function () {
	<?php
		if(isset($proveedores)):
			$totalcompras = 0;
			foreach($proveedores as $proveedor):
				$totalcompras+=$proveedor->total_compras;
			endforeach;
	?>
    $('#grafico-comprasproveedor-container').highcharts({
		chart: {
            type: 'column'
        },
       title: {
            text: 'Grafico de Compras a Proveedores',
            x: -20
        },
        subtitle: {
            text: 'Fuente: Base de Datos Miracle v1.5.0',
            x: -20
        },
        xAxis: {
            type: 'category'
        },
        yAxis: {
            title: {
                text: 'Dolares ($)'
            }

        },
        legend: {
            enabled: false
        },
        plotOptions: {
            series: {
                borderWidth: 0,
                dataLabels: {
                    enabled: <?php echo $valores;?>,
                    format: '{point.y:.1f} dolares'
                }
            }
        },

        tooltip: {
            headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
            pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.2f}</b> dolares<br/>'
        },
		series: [{
            name: "Compras",
            colorByPoint: true,
            data: [
					<?php
						foreach($proveedores as $proveedor):
							if($proveedor->total_compras > 0){
								echo '{name: "'.$proveedor->nombre_proveedor.'",';
								echo 'y:'.$proveedor->total_compras.',drilldown: "'.$proveedor->nombre_proveedor.'"},';
							}
						endforeach;
					?>
			]
        }],
        drilldown: {
            series: [
				<?php
					foreach($proveedores as $proveedor):
						echo '{name: "'.$proveedor->nombre_proveedor.'",';
						echo 'id: "'.$proveedor->nombre_proveedor.'",data:[';
							if(is_array($proveedor->productos_compras)){
								$contador = 0;
								$compras_producto = 0;
								$arrayProveedor = json_decode(json_encode($proveedor->productos_compras),true);
								usort($arrayProveedor, "cmp");
								foreach($arrayProveedor as $compras){
									if($contador < 5 && $compras["Total"] > 0){
										echo '["'.$compras["desc_producto"].'",'.$compras["Total"].'],';										
									}else{
										$compras_producto+= $compras["Total"];
									}
									$contador++;
								}
								if($compras_producto > 0){
									echo '["Resto de Productos",'.$compras_producto.'],';	
								}											
							}
						echo "]},";
					endforeach;
				?>
			]
        }
    });
	<?php
		else:
	?>
	toastr.options = {
	  "closeButton": true,
	  "progressBar": true,
	  "positionClass": "toast-top-right"
	}
	toastr.error('No hay informacion obtenida para dibujar un grafico');
	<?php
		endif;
	?>
});
</script>
<?php
	function cmp($a, $b){
		return $b['Total'] - $a['Total'];
	}
?>