<div id="grafico-utilidades-container"></div>
<script>
$(function () {
	<?php
		if(isset($ventas)):
	?>
    $('#grafico-utilidades-container').highcharts({
        title: {
            text: 'Grafico de Utilidades Mensuales',
            x: -20 //center 2015-01-01
        },
        subtitle: {
            text: 'Fuente: Base de Datos Miracle v1.5.0',
            x: -20
        },
        xAxis: {
            categories: [
				<?php
					$primerfecha = substr($ventas[0]->fecha_venta,0,10);
					foreach($ventas as $venta):
						if($primerfecha == substr($venta->fecha_venta,0,10)){
							
						}else{
							$fecha = explode("-",$primerfecha);
							echo '"'.$fecha[2].' '.substr(TraducirMes($fecha[1]),0,4).' '.substr($fecha[0],2,4).'",';
							$primerfecha = substr($venta->fecha_venta,0,10);
						}
					endforeach;
					$fecha = explode("-",$primerfecha);
					echo '"'.$fecha[2].' '.substr(TraducirMes($fecha[1]),0,4).' '.substr($fecha[0],2,4).'",';
				?>
			]
        },
        yAxis: {
            title: {
                text: 'Dolares ($)'
            },
            plotLines: [{
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
		plotOptions: {
            series: {
                dataLabels: {
                    enabled: <?php echo $valores;?>,
					format: '{point.y:.1f} dolares'
                }
            }
        },
        tooltip: {
            valueSuffix: ' dolares'
        },
        legend: {
            layout: 'vertical',
            align: 'right',
            verticalAlign: 'middle',
            borderWidth: 0
        },
        series:[
			{
				name: 'Ventas',
				data: [
					<?php
						$ventasmensuales = 0;
						$primerfecha = substr($ventas[0]->fecha_venta,0,10);
						foreach($ventas as $venta):
							if($primerfecha == substr($venta->fecha_venta,0,10)){
								$ventasmensuales+= $venta->Total;
							}else{
								echo $ventasmensuales.",";
								
								$primerfecha = substr($venta->fecha_venta,0,10);
								$ventasmensuales = 0;
								
								$ventasmensuales+= $venta->Total;
							}
						endforeach;
						echo $ventasmensuales.",";
					?>
				]
			},
			{
				name: 'Costos',
				data: [
					<?php
						$costos = 0;
						$primerfecha = substr($ventas[0]->fecha_venta,0,10);
						foreach($ventas as $venta):
							if($primerfecha == substr($venta->fecha_venta,0,10)){
								if(is_array($venta->ventas_salidas)){
									foreach($venta->ventas_salidas as $costo_productos){
										$costos+=$costo_productos->costo;
									}
								}else{
									$costos+= 0;
								}
							}else{
								echo $costos.",";
								
								$primerfecha = substr($venta->fecha_venta,0,10);
								$costos = 0;
								
								if(is_array($venta->ventas_salidas)){
									foreach($venta->ventas_salidas as $costo_productos){
										$costos+=$costo_productos->costo;
									}
								}else{
									$costos+= 0;
								}
							}
						endforeach;
						echo $costos.",";
					?>
				]
			},
			{
				name: 'Ganancias',
				data: [
					<?php
						$ventasmensuales = 0;
						$costos = 0;
						$primerfecha = substr($ventas[0]->fecha_venta,0,10);
						foreach($ventas as $venta):
							if($primerfecha == substr($venta->fecha_venta,0,10)){
								$ventasmensuales+= $venta->Total;
								if(is_array($venta->ventas_salidas)){
									foreach($venta->ventas_salidas as $costo_productos){
										$costos+=$costo_productos->costo;
									}
								}else{
									$costos+= 0;
								}
							}else{
								echo ($ventasmensuales - $costos).",";
								
								$primerfecha = substr($venta->fecha_venta,0,10);
								$ventasmensuales = 0;
								$costos = 0;
								
								$ventasmensuales+= $venta->Total;
								if(is_array($venta->ventas_salidas)){
									foreach($venta->ventas_salidas as $costo_productos){
										$costos+=$costo_productos->costo;
									}
								}else{
									$costos+= 0;
								}
							}
						endforeach;
						echo ($ventasmensuales - $costos).",";
					?>
				]
			}
		]
    });
	<?php
		else:
	?>
	toastr.options = {
	  "closeButton": true,
	  "progressBar": true,
	  "positionClass": "toast-top-right"
	}
	toastr.error('No hay informacion obtenida para dibujar un grafico');
	<?php
		endif;
	?>
});
</script>
<?php
	function TraducirMes($month){
		switch($month){
			case '01':
					return $mes = 'Enero';
				break;
			case '02':
					return $mes = 'Febrero';
				break;
			case '03':
					return $mes = 'Marzo';
				break;
			case '04':
					return $mes = 'Abril';
				break;
			case '05':
					return $mes = 'Mayo';
				break;
			case '06':
					return $mes = 'Junio';
				break;
			case '07':
					return $mes = 'Julio';
				break;
			case '08':
					return $mes = 'Agosto';
				break;
			case '09':
					return $mes = 'Septiembre';
				break;
			case '10':
					return $mes = 'Octubre';
				break;
			case '11':
					return $mes = 'Noviembre';
				break;
			case '12':
					return $mes = 'Diciembre';
				break;
		}
	}
?>