<div id="grafico-ventas-vendedor-container"></div>
<script>
$(function () {
	<?php
		if(isset($result)):
	?>
    $('#grafico-ventas-vendedor-container').highcharts({
        title: {
            text: 'Grafico de Ventas Diarias por Vendedor',
            x: -20 //center
        },
        subtitle: {
            text: 'Fuente: Base de Datos Miracle v1.5.0',
            x: -20
        },
        xAxis: {
            categories: [
				<?php
					$primerfecha = $result[0]->Fecha;
					foreach($result as $res):
						if($primerfecha != $res->Fecha){
							$fecha = explode("-",$primerfecha);
							echo '"'.$fecha[2].' de '.TraducirMes($fecha[1]).'",';
							$primerfecha = $res->Fecha;
						}						
					endforeach;
					$fecha = explode("-",$primerfecha);
					echo '"'.$fecha[2].' de '.TraducirMes($fecha[1]).'",';
				?>
			]
        },
		yAxis: {
            title: {
                text: 'Dolares ($)'
            },
            plotLines: [{
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        tooltip: {
            valueSuffix: ' dolares'
        },
        labels: {
            items: [{
                html: 'Total Ventas por Vendedor',
                style: {
                    left: '50px',
                    top: '-20px',
                    color: (Highcharts.theme && Highcharts.theme.textColor) || 'black'
                }
            }]
        },
		plotOptions: {
            series: {
                dataLabels: {
                    enabled: <?php echo $valores;?>,
					format: '{point.y:.1f} dolares'
                }
            }
        },
        series: [
			<?php
				$totales = [];
				foreach($usuarios as $usuario):
					$total_usuario = 0;
					echo '{type: "column",name: "'.$usuario->nombre_usuario.'",data: [';
						foreach($usuario->ventas as $ventas){
							$ventas_ = 0;
							if($ventas->ventas != ""){
								$ventas_ = $ventas->ventas;
							}
							echo number_format($ventas_,2).",";
							$total_usuario+= $ventas_;
						}
					echo ']},';
					$totales[] = array(
						"usuario" => $usuario->nombre_usuario,
						"total" => $total_usuario
					);
				endforeach;
			?>
			{
				type: 'spline',
				name: 'Promedio',
				data: [
					<?php
						foreach($promedios as $promedio):
							echo number_format($promedio->total / $promedio->dividir,2).",";
						endforeach;
					?>
				],
				marker: {
					lineWidth: 2,
					lineColor: Highcharts.getOptions().colors[3],
					fillColor: 'white'
				}
			},
			{
				type: 'pie',
				name: 'Total Ventas',
				data: [
					<?php
						$totales_obj = json_decode (json_encode ($totales), FALSE);
						foreach($totales_obj as $total):
							echo '{name: "'.$total->usuario.'",y: '.$total->total.'},';
						endforeach;
					?>
				],
				center: [100, 30],
				size: 100,
				showInLegend: false,
				dataLabels: {
					enabled: <?php echo $valores;?>
				}
			}
		]
    });
	<?php
		else:
	?>
	toastr.options = {
	  "closeButton": true,
	  "progressBar": true,
	  "positionClass": "toast-top-right"
	}
	toastr.error('No hay informacion obtenida para dibujar un grafico');
	<?php
		endif;
	?>
});
</script>
<?php
	function TraducirMes($month){
		switch($month){
			case '01':
					return $mes = 'Enero';
				break;
			case '02':
					return $mes = 'Febrero';
				break;
			case '03':
					return $mes = 'Marzo';
				break;
			case '04':
					return $mes = 'Abril';
				break;
			case '05':
					return $mes = 'Mayo';
				break;
			case '06':
					return $mes = 'Junio';
				break;
			case '07':
					return $mes = 'Julio';
				break;
			case '08':
					return $mes = 'Agosto';
				break;
			case '09':
					return $mes = 'Septiembre';
				break;
			case '10':
					return $mes = 'Octubre';
				break;
			case '11':
					return $mes = 'Noviembre';
				break;
			case '12':
					return $mes = 'Diciembre';
				break;
		}
	}
?>