<?php
	$this->load->library('fpdf');

    $GLOBALS['data'] = array(
        'Empresa' => $configs['NombreEmpresa'],
        'Direccion' => $configs['DireccionEmpresa'],
        'Logo' => base_url($configs['LogoEmpresa']),
        'Telefono' => $configs['TelefonoEmpresa'],
		'Numero' => $numero
    );
    $destino = ($traslado ? strtoupper(utf8_decode($traslado->comentario2_transaccion)) : "");
    $fecha = ($traslado ? date("d-m-Y H:i", strtotime($traslado->registro_transaccion)) : "");
    $usuario = ($traslado ? strtoupper(utf8_decode($traslado->nombre_usuario)) :"");
    $comentario = ($traslado ? utf8_decode($traslado->comentario1_transaccion): "");
    class PDF extends FPDF{
    
        function Header(){
            global $data;
            $this->Image($data['Logo'],10,6,25);
            $this->SetFont('Arial','B',12);
            $this->text(42, 11, strtoupper(utf8_decode($data['Empresa'])));
            $this->SetFont('Arial','',9);
            $this->text(42, 15, utf8_decode($data['Direccion']));
            $this->text(42, 19, "Tel.".utf8_decode($data['Telefono']));
            $this->SetXY(150, 9);
            $this->SetFont('Arial','B',9);
            $this->MultiCell(45, 5, "NOTA DE TRASLADO \n No. ".$data['Numero'], 1, 'C');
            $this->SetFont('Arial','',8);
            $this->text(165, 22.5, "Pagina ".$this->PageNo()."de {nb}");
			$this->ln(2);
        }
        
        function Footer(){
            $this->SetY(-15);
            $this->SetFont('Arial','I',7);
            $this->Cell(40,6,utf8_decode('Miracle v1.5 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),0,1,'L');
        }
    }
    $pdf = new PDF();
    $pdf->AliasNbPages(); 
    $pdf->setTitle('Nota traslado No '.$GLOBALS['data']['Numero']);
    $pdf->setAuthor('Miracle v1.5 - Xypnos');
    $pdf->AddPage('P','Letter');


    /** */
    $pdf->SetFont('Arial','b',10);
    $pdf->text(10, 35, "Destino: ");
    $pdf->text(110, 35, "Fecha: ");
    $pdf->text(150, 35, "Usuario: ");
    $pdf->text(10, 41, "Comentarios: ");
    $pdf->SetFont('Arial','',9);
    $pdf->text(25, 35, $destino);
    $pdf->text(122, 35, $fecha);
    $pdf->text(165, 35, $usuario);
    $pdf->text(34, 41, $comentario);

    /*Header Tabla*/
    $pdf->SetY(46);
	$pdf->SetFont('Arial','B',10);
	$pdf->Cell(45,6,'Referencia',1,0,'C');
	$pdf->Cell(90,6,'Producto',1,0,'C');
	$pdf->Cell(20,6,'Cantidad',1,0,'C');
	$pdf->Cell(20,6,'Precio',1,0,'C');
	$pdf->Cell(20,6,'Total',1,1,'C');
    $pdf->SetFont('Arial','',8);
    $pdf->SetFillColor(233,233,233);
    $fill = true;
    foreach($productos as $producto){
        $pdf->Cell(45,6.5,$producto->ref,"LB",0,'L',$fill);
	    $pdf->Cell(90,6.5,$producto->desc,"B",0,'L',$fill);
	    $pdf->Cell(20,6.5,$producto->cant,"B",0,'R',$fill);
	    $pdf->Cell(20,6.5,$producto->costo,"B",0,'R',$fill);
	    $pdf->Cell(20,6.5,number_format($producto->cant * $producto->costo,2),"RB",1,'R',$fill);
        $fill = ($fill ? false : true);
    }

    $pdf->Output('Traslado No '+$GLOBALS['data']['Numero'],'I');