<?php
	$this->load->library('fpdf');
	
	$GLOBALS['dataArray'] = array(
        'Empresa' => $configs['NombreEmpresa'],
        'Direccion' => $configs['DireccionEmpresa'],
        'Logo' => base_url($configs['LogoEmpresa'])
    );
	
	class PDF extends FPDF{
    
        function Header(){
            global $dataArray;
            $this->Image($dataArray['Logo'],250,5,25);
            $this->SetFont('Arial','B',15);
            $this->SetY(6);
            $this->Cell(0,8,utf8_decode('Reporte Historico de Costos'),0,1,'C');
            $this->SetFont('Arial','B',12);
            $this->SetY(12);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Empresa'])),0,1,'C');
            $this->SetY(17);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Direccion'])),0,1,'C');
            $this->Ln(3);
            
            /*Header Tabla*/
            $this->SetFont('Arial','B',10);
            $this->Cell(30,8,'Fecha',1,0,'C');
            $this->Cell(55,8,'Producto',1,0,'C');
            $this->Cell(50,8,'Proveedor',1,0,'C');
            $this->Cell(40,8,'Documento',1,0,'C');
            $this->Cell(30,8,'Cantidad',1,0,'C');
            $this->Cell(30,8,'Costo',1,0,'C');
            $this->Cell(30,8,'Total',1,1,'C');
            $this->SetFont('Arial','',8);
        }
        
        function Footer(){
            $this->SetY(-15);
            $this->SetFont('Arial','I',7);
            $this->Cell(200,6,utf8_decode('Pagina '.$this->PageNo().'/{nb}'),0,0,'L');
            $this->Cell(60,6,utf8_decode(gmdate('d-m-Y H:i:s', strtotime('- 6 hours'))),0,1,'R');
            $this->Cell(60,6,utf8_decode('Miracle v1.5 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),0,1,'L');
        }
    }
	
	$pdf = new PDF();
    $pdf->AliasNbPages(); 
    $pdf->setTitle('Reporte Historico de Costos');
    $pdf->setAuthor('Miracle v1.5 - Xypnos');
    $pdf->AddPage('L','Letter');
    
    /*Cuerpo del Documento*/
	if(isset($costos) && count($costos) > 0):
        foreach($costos as $costo):
            $pdf->Cell(30,8,utf8_decode(ucwords($costo->fecha_entrada)),1,0,'L');
            $pdf->Cell(55,8,utf8_decode(ucwords($costo->desc_presentacion)),1,0,'L');
            $pdf->Cell(50,8,utf8_decode(ucwords($costo->nombre_proveedor)),1,0,'L');
			
			switch($costo->documento_compra){
				case "0":
						$pdf->Cell(40,8,utf8_decode(ucwords("CCF ".$costo->num_doc_compra)),1,0,'L');
					break;
				case "1":
						$pdf->Cell(40,8,utf8_decode(ucwords("Factura ".$costo->num_doc_compra)),1,0,'L');
					break;
				case "2":
						$pdf->Cell(40,8,utf8_decode(ucwords("Nota de Envio ".$costo->num_doc_compra)),1,0,'L');
					break;
			}
			
			$pdf->Cell(30,8,utf8_decode(ucwords($costo->cant_entrada)),1,0,'L');
			$pdf->Cell(30,8,utf8_decode(ucwords($costo->costo_entrada)),1,0,'L');
			$pdf->Cell(30,8,utf8_decode(ucwords($costo->costo_entrada*$costo->cant_entrada)),1,1,'R');
        endforeach;
    endif;
    
    /*Exportamos el PDF*/
    $pdf->Output('Reporte Historico de Costos','I');
?>