<?php
	$this->load->library('fpdf');
	
	$GLOBALS['dataArray'] = array(
        'Empresa' => $configs['NombreEmpresa'],
        'Direccion' => $configs['DireccionEmpresa'],
        'Logo' => base_url($configs['LogoEmpresa']),
		'Imagen' => $imagen
    );
	
	class PDF extends FPDF{
    
        function Header(){
            global $dataArray;
            $this->Image($dataArray['Logo'],185,5,25);
            $this->SetFont('Arial','B',15);
            $this->SetY(6);
            $this->Cell(0,8,utf8_decode('Catalogo de Productos'),0,1,'C');
            $this->SetFont('Arial','B',12);
            $this->SetY(12);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Empresa'])),0,1,'C');
            $this->SetY(17);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Direccion'])),0,1,'C');
            $this->Ln(3);
			
			$this->SetFont('Arial','',11);
        }
        
        function Footer(){
            $this->SetY(-15);
            $this->SetFont('Arial','I',7);
            $this->Cell(135,6,utf8_decode('Pagina '.$this->PageNo().'/{nb}'),0,0,'L');
            $this->Cell(60,6,utf8_decode(gmdate('d-m-Y H:i:s', strtotime('- 6 hours'))),0,1,'R');
            $this->Cell(60,6,utf8_decode('Miracle v1.5 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),0,1,'L');
        }
    }
	
	$pdf = new PDF();
    $pdf->AliasNbPages(); 
    $pdf->setTitle('Reporte de Inventario');
    $pdf->setAuthor('Miracle v1.5 - Xypnos');
    $pdf->AddPage('P','Letter');
    
    /*Cuerpo del Documento*/
    if(isset($productos) && count($productos) > 0):
		$x = $pdf->GetX();
		$y = $pdf->GetY();
		$y_bisde = $y + 12;
		$el = 1;
		$par = true;
		
		foreach($productos as $producto):
			if($el > 8){
				$el = 1;
				$pdf->AddPage('P','Letter');
				$x = $pdf->GetX();
				$y = $pdf->GetY();
				$y_bisde = $y + 12;
			}
			if($par){
				$par = false;
				$y_bisde = $y + 12;
				$pdf->Rect($x,$y,95,58);
				if($imagen == 1){
					if($producto->imagen_producto != ""){
						$pdf->Image(base_url($producto->imagen_producto),$x + 64,$y + 1,30);
					}else{
						$pdf->Image(base_url($configs['LogoEmpresa']),$x + 64,$y + 1,30);
					}	
				}			
				$pdf->SetFont('Arial','B',12);
				$pdf->Cell(95,12,utf8_decode(ucwords($producto->desc_producto)),0,1,'L');
				if($sku == 1){
					$pdf->SetFont('Arial','',11);
					$pdf->Cell(30,6,utf8_decode(ucwords("SKU:")),0,0,'L');
					$pdf->SetFont('Arial','B',11);
					$pdf->Cell(65,6,utf8_decode(ucwords($producto->sku_producto)),0,1,'L');
				}
				
				if($precio1 == 1){
					$pdf->SetFont('Arial','',11);
					$pdf->Cell(30,6,utf8_decode(ucwords("Precio 1:")),0,0,'L');
					$pdf->SetFont('Arial','B',11);
					$pdf->Cell(65,6,utf8_decode(ucwords($producto->precio1_producto)),0,1,'L');
				}
				
				if($precio2 == 1){
					$pdf->SetFont('Arial','',11);
					$pdf->Cell(30,6,utf8_decode(ucwords("Precio 2:")),0,0,'L');
					$pdf->SetFont('Arial','B',11);
					$pdf->Cell(65,6,utf8_decode(ucwords($producto->precio2_producto)),0,1,'L');
				}
				
				if($precio3 == 1){
					$pdf->SetFont('Arial','',11);
					$pdf->Cell(30,6,utf8_decode(ucwords("Precio 3:")),0,0,'L');
					$pdf->SetFont('Arial','B',11);
					$pdf->Cell(65,6,utf8_decode(ucwords($producto->precio3_producto)),0,1,'L');
				}
				
				if($groupname == 1){
					$pdf->SetFont('Arial','',11);
					$pdf->Cell(30,6,utf8_decode(ucwords("Grupo:")),0,0,'L');
					$pdf->SetFont('Arial','B',11);
					$pdf->Cell(65,6,utf8_decode(ucwords($producto->nombre_grupo)),0,1,'L');
				}
				
				if($subgroupname == 1){
					$pdf->SetFont('Arial','',11);
					$pdf->Cell(30,6,utf8_decode(ucwords("SubGrupo:")),0,0,'L');
					$pdf->SetFont('Arial','B',11);
					$pdf->Cell(65,6,utf8_decode(ucwords($producto->nombre_subgrupo)),0,1,'L');
				}
				
				if($informacion == 1){
					$pdf->SetFont('Arial','',11);
					$pdf->Cell(30,6,utf8_decode(ucwords("Informacion:")),0,0,'L');
					$pdf->SetFont('Arial','B',11);
					$pdf->Cell(65,6,utf8_decode(ucwords($producto->info_producto)),0,1,'L');
				}
				
				$pdf->SetX($x+= 102);					
			}else{
				$par = true;
				$pdf->Rect($x,$y,95,58);
				if($imagen == 1){
					if($producto->imagen_producto != ""){
						$pdf->Image(base_url($producto->imagen_producto),$x + 64,$y + 1,30);
					}else{
						$pdf->Image(base_url($configs['LogoEmpresa']),$x + 64,$y + 1,30);
					}	
				}	
				$pdf->SetXY($x,$y);
				$pdf->SetFont('Arial','B',12);
				$pdf->Cell(95,12,utf8_decode(ucwords($producto->desc_producto)),0,1,'L');
				if($sku == 1){
					$pdf->SetXY($x,$y_bisde);
					$pdf->SetFont('Arial','',11);
					$pdf->Cell(30,6,utf8_decode(ucwords("SKU:")),0,0,'L');
					$pdf->SetFont('Arial','B',11);
					$pdf->Cell(65,6,utf8_decode(ucwords($producto->sku_producto)),0,1,'L');
					$y_bisde+= 6;
				}
				
				if($precio1 == 1){
					$pdf->SetXY($x,$y_bisde);
					$pdf->SetFont('Arial','',11);
					$pdf->Cell(30,6,utf8_decode(ucwords("Precio 1:")),0,0,'L');
					$pdf->SetFont('Arial','B',11);
					$pdf->Cell(65,6,utf8_decode(ucwords($producto->precio1_producto)),0,1,'L');
					$y_bisde+= 6;
				}
				
				if($precio2 == 1){
					$pdf->SetXY($x,$y_bisde);
					$pdf->SetFont('Arial','',11);
					$pdf->Cell(30,6,utf8_decode(ucwords("Precio 2:")),0,0,'L');
					$pdf->SetFont('Arial','B',11);
					$pdf->Cell(65,6,utf8_decode(ucwords($producto->precio2_producto)),0,1,'L');
					$y_bisde+= 6;
				}
				
				if($precio3 == 1){
					$pdf->SetXY($x,$y_bisde);
					$pdf->SetFont('Arial','',11);
					$pdf->Cell(30,6,utf8_decode(ucwords("Precio 3:")),0,0,'L');
					$pdf->SetFont('Arial','B',11);
					$pdf->Cell(65,6,utf8_decode(ucwords($producto->precio3_producto)),0,1,'L');
					$y_bisde+= 6;
				}
				
				if($groupname == 1){
					$pdf->SetXY($x,$y_bisde);
					$pdf->SetFont('Arial','',11);
					$pdf->Cell(30,6,utf8_decode(ucwords("Grupo:")),0,0,'L');
					$pdf->SetFont('Arial','B',11);
					$pdf->Cell(65,6,utf8_decode(ucwords($producto->nombre_grupo)),0,1,'L');
					$y_bisde+= 6;
				}
				
				if($subgroupname == 1){
					$pdf->SetXY($x,$y_bisde);
					$pdf->SetFont('Arial','',11);
					$pdf->Cell(30,6,utf8_decode(ucwords("SubGrupo:")),0,0,'L');
					$pdf->SetFont('Arial','B',11);
					$pdf->Cell(65,6,utf8_decode(ucwords($producto->nombre_subgrupo)),0,1,'L');
					$y_bisde+= 6;
				}
				
				if($informacion == 1){
					$pdf->SetXY($x,$y_bisde);
					$pdf->SetFont('Arial','',11);
					$pdf->Cell(30,6,utf8_decode(ucwords("Informacion:")),0,0,'L');
					$pdf->SetFont('Arial','B',11);
					$pdf->Cell(65,6,utf8_decode(ucwords($producto->info_producto)),0,1,'L');
				}
				
				$pdf->SetXY($x = 10,$y+= 58);
			}
			$el+=1;
		endforeach;
    endif;
    
    /*Exportamos el PDF*/
    $pdf->Output('Reporte de Catalogo Inventario','I');
?>