<div class="row">
	<div class="col-lg-6">
		<div class="ibox float-e-margins">
			<div class="ibox-title">
				<h5>Salidas por da&ntilde;o o vencimiento</h5>
			</div>
			<div class="ibox-content">
				<div class="row">
					<div class="col-lg-12">
						<div class="row">
							<div class="col-sm-3">
								<label>Tipo</label>
								<select class="form-control" id="reportes-vencimiento-tipo">
									<option value='mensual'>Mensual</option>
									<option value='diario'>Diario</option>
								</select>
							</div>
							<div class="col-sm-2">
								<label>Desde</label>
								<input type="text" class="form-control" id="reportes-vencimiento-desde-month" readonly>
								<input type="text" class="form-control" id="reportes-vencimiento-desde-days" readonly style="display:none;">
							</div>
							<div class="col-sm-2">
								<label>Hasta</label>
								<input type="text" class="form-control" id="reportes-vencimiento-hasta-month" readonly>
								<input type="text" class="form-control" id="reportes-vencimiento-hasta-days" readonly style="display:none;">
							</div>
							<div class="col-sm-2">
								<label>Con Valores</label>
								<input type="checkbox" class="i-checks" id="reportes-vencimiento-mostrar">
							</div>
							<div class="col-sm-3">
								<button class="btn btn-info m-t-md" id="construirGraficoVencimiento">Construir</button>
							</div>
						</div>
					</div>
				</div>
				<div class="hr-line-dashed"></div>
				<div class="vencimiento-ajax-content" style="height:375px;">
				</div>
			</div>
		</div>
	</div>
	<!---->
	<div class="col-lg-6">
		<div class="ibox float-e-margins">
			<div class="ibox-title">
				<h5>Salidas perdida o extrav&iacute;o</h5>
			</div>
			<div class="ibox-content">
				<div class="row">
					<div class="col-lg-12">
						<div class="row">
							<div class="col-sm-3">
								<label>Tipo</label>
								<select class="form-control" id="reportes-perdida-tipo">
									<option value='mensual'>Mensual</option>
									<option value='diario'>Diario</option>
								</select>
							</div>
							<div class="col-sm-2">
								<label>Desde</label>
								<input type="text" class="form-control" id="reportes-perdida-desde-month" readonly>
								<input type="text" class="form-control" id="reportes-perdida-desde-days" readonly style="display:none;">
							</div>
							<div class="col-sm-2">
								<label>Hasta</label>
								<input type="text" class="form-control" id="reportes-perdida-hasta-month" readonly>
								<input type="text" class="form-control" id="reportes-perdida-hasta-days" readonly style="display:none;">
							</div>
							<div class="col-sm-2">
								<label>Con Valores</label>
								<input type="checkbox" class="i-checks" id="reportes-perdida-mostrar">
							</div>
							<div class="col-sm-3">
								<button class="btn btn-info m-t-md" id="construirGraficoPerdida">Construir</button>
							</div>
						</div>
					</div>
				</div>
				<div class="hr-line-dashed"></div>
				<div class="perdida-ajax-content" style="height:375px;">
				</div>
			</div>
		</div>
	</div>
</div>
<div class="row">
	<div class="col-lg-6">
		<div class="ibox float-e-margins">
			<div class="ibox-title">
				<h5>Salidas por devolici&oacute;n a proveedor</h5>
			</div>
			<div class="ibox-content">
				<div class="row">
					<div class="col-lg-12">
						<div class="row">
							<div class="col-sm-3">
								<label>Tipo</label>
								<select class="form-control" id="reportes-devolucion-tipo">
									<option value='mensual'>Mensual</option>
									<option value='diario'>Diario</option>
								</select>
							</div>
							<div class="col-sm-2">
								<label>Desde</label>
								<input type="text" class="form-control" id="reportes-devolucion-desde-month" readonly>
								<input type="text" class="form-control" id="reportes-devolucion-desde-days" readonly style="display:none;">
							</div>
							<div class="col-sm-2">
								<label>Hasta</label>
								<input type="text" class="form-control" id="reportes-devolucion-hasta-month" readonly>
								<input type="text" class="form-control" id="reportes-devolucion-hasta-days" readonly style="display:none;">
							</div>
							<div class="col-sm-2">
								<label>Con Valores</label>
								<input type="checkbox" class="i-checks" id="reportes-devolucion-mostrar">
							</div>
							<div class="col-sm-3">
								<button class="btn btn-info m-t-md" id="construirGraficoDevolucion">Construir</button>
							</div>
						</div>
					</div>
				</div>
				<div class="hr-line-dashed"></div>
				<div class="devolucion-ajax-content" style="height:375px;">
				</div>
			</div>
		</div>
	</div>
	<!---->
	<div class="col-lg-6">
		<div class="ibox float-e-margins">
			<div class="ibox-title">
				<h5>Salidas por consumo interno</h5>
			</div>
			<div class="ibox-content">
				<div class="row">
					<div class="col-lg-12">
						<div class="row">
							<div class="col-sm-3">
								<label>Tipo</label>
								<select class="form-control" id="reportes-consumo-tipo">
									<option value='mensual'>Mensual</option>
									<option value='diario'>Diario</option>
								</select>
							</div>
							<div class="col-sm-2">
								<label>Desde</label>
								<input type="text" class="form-control" id="reportes-consumo-desde-month" readonly>
								<input type="text" class="form-control" id="reportes-consumo-desde-days" readonly style="display:none;">
							</div>
							<div class="col-sm-2">
								<label>Hasta</label>
								<input type="text" class="form-control" id="reportes-consumo-hasta-month" readonly>
								<input type="text" class="form-control" id="reportes-consumo-hasta-days" readonly style="display:none;">
							</div>
							<div class="col-sm-2">
								<label>Con Valores</label>
								<input type="checkbox" class="i-checks" id="reportes-consumo-mostrar">
							</div>
							<div class="col-sm-3">
								<button class="btn btn-info m-t-md" id="construirGraficoConsumo">Construir</button>
							</div>
						</div>
					</div>
				</div>
				<div class="hr-line-dashed"></div>
				<div class="consumo-ajax-content" style="height:375px;">
				</div>
			</div>
		</div>
	</div>
</div>
<script>
$(document).ready(function(){
	$('.i-checks').iCheck({
		checkboxClass: 'icheckbox_square-green',
		radioClass: 'iradio_square-green',
	});
	
	/*Vencimiento*/
	$("#construirGraficoVencimiento").on("click",function(){
		var valid = true;
		var fechadesde = "";
		var fechahasta = "";
		var valores = false;
		
		if($("#reportes-vencimiento-mostrar").is(":checked")){
			valores = true;
		}
		
		if($('#reportes-vencimiento-tipo').val()=='mensual'){
			if($('#reportes-vencimiento-desde-month').val() == ""){
				$('#reportes-vencimiento-desde-month').focus();
				valid = false;
			}else if($('#reportes-vencimiento-hasta-month').val() == ""){
				$('#reportes-vencimiento-hasta-month').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-vencimiento-desde-month').val();
				fechahasta = $('#reportes-vencimiento-hasta-month').val();
			}
		}else{
			if($('#reportes-vencimiento-desde-days').val() == ""){
				$('#reportes-vencimiento-desde-days').focus();
				valid = false;
			}else if($('#reportes-vencimiento-hasta-days').val() == ""){
				$('#reportes-vencimiento-hasta-days').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-vencimiento-desde-days').val();
				fechahasta = $('#reportes-vencimiento-hasta-days').val();
			}
		}
		if(valid){
			$.get('<?php echo base_url();?>reportes/grafico_salidas_vencimiento?fechadesde='+fechadesde+'&fechahasta='+fechahasta+'&tipo='+$('#reportes-vencimiento-tipo').val()+'&valores='+valores)
			.done(function(data){                
				$('.vencimiento-ajax-content').html(data);
			});
		}else{
			toastr.options = {
			  "closeButton": true,
			  "progressBar": true,
			  "positionClass": "toast-top-right"
			}
			toastr.error('Hace falta informacion necesaria para enviar el formulario, favor verifique');
		}		
	});
	
	$('#reportes-vencimiento-tipo').change(function(){
		if($(this).val()=='mensual'){
			$('#reportes-vencimiento-desde-month, #reportes-vencimiento-hasta-month').val('');
			$('#reportes-vencimiento-desde-days, #reportes-vencimiento-hasta-days').val('');
			
			$('#reportes-vencimiento-desde-month, #reportes-vencimiento-hasta-month').show();
			$('#reportes-vencimiento-desde-days, #reportes-vencimiento-hasta-days').hide();
		}else{
			$('#reportes-vencimiento-desde-month, #reportes-vencimiento-hasta-month').val('');
			$('#reportes-vencimiento-desde-days, #reportes-vencimiento-hasta-days').val('');
			
			$('#reportes-vencimiento-desde-month, #reportes-vencimiento-hasta-month').hide();
			$('#reportes-vencimiento-desde-days, #reportes-vencimiento-hasta-days').show();
		}
	});
	$('#reportes-vencimiento-desde-month, #reportes-vencimiento-hasta-month').datepicker({
		language:'es',
		autoclose:true,
		format: "yyyy-mm", 
		startView: "months", 
		minViewMode: "months" 
	});
	var inicio_vencimiento_diario = $('#reportes-vencimiento-desde-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		autoclose:true
	}).on('changeDate', function (ev) {
			var newDate = new Date(ev.date);
			newDate.setDate(newDate.getDate());
			fin_vencimiento_diario.datepicker("update", newDate);
			$('#reportes-vencimiento-hasta-days')[0].focus();
	});
	var fin_vencimiento_diario = $('#reportes-vencimiento-hasta-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		beforeShowDay: function (date) {
			if (!inicio_vencimiento_diario.datepicker("getDate").valueOf()) {
				return date.valueOf() >= new Date().valueOf();
			} else {
				return date.valueOf() > inicio_vencimiento_diario.datepicker("getDate").valueOf()-1;
			}
		},
		autoclose: true

	}).on('changeDate', function (ev) {}); 
	
	/*Perdida*/
	$("#construirGraficoPerdida").on("click",function(){
		var valid = true;
		var fechadesde = "";
		var fechahasta = "";
		var valores = false;
		
		if($("#reportes-perdida-mostrar").is(":checked")){
			valores = true;
		}
		
		if($('#reportes-perdida-tipo').val()=='mensual'){
			if($('#reportes-perdida-desde-month').val() == ""){
				$('#reportes-perdida-desde-month').focus();
				valid = false;
			}else if($('#reportes-perdida-hasta-month').val() == ""){
				$('#reportes-perdida-hasta-month').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-perdida-desde-month').val();
				fechahasta = $('#reportes-perdida-hasta-month').val();
			}
		}else{
			if($('#reportes-perdida-desde-days').val() == ""){
				$('#reportes-perdida-desde-days').focus();
				valid = false;
			}else if($('#reportes-perdida-hasta-days').val() == ""){
				$('#reportes-perdida-hasta-days').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-perdida-desde-days').val();
				fechahasta = $('#reportes-perdida-hasta-days').val();
			}
		}
		if(valid){
			$.get('<?php echo base_url();?>reportes/grafico_salidas_perdida?fechadesde='+fechadesde+'&fechahasta='+fechahasta+'&tipo='+$('#reportes-perdida-tipo').val()+'&valores='+valores)
			.done(function(data){                
				$('.perdida-ajax-content').html(data);
			});
		}else{
			toastr.options = {
			  "closeButton": true,
			  "progressBar": true,
			  "positionClass": "toast-top-right"
			}
			toastr.error('Hace falta informacion necesaria para enviar el formulario, favor verifique');
		}		
	});
	
	$('#reportes-perdida-tipo').change(function(){
		if($(this).val()=='mensual'){
			$('#reportes-perdida-desde-month, #reportes-perdida-hasta-month').val('');
			$('#reportes-perdida-desde-days, #reportes-perdida-hasta-days').val('');
			
			$('#reportes-perdida-desde-month, #reportes-perdida-hasta-month').show();
			$('#reportes-perdida-desde-days, #reportes-perdida-hasta-days').hide();
		}else{
			$('#reportes-perdida-desde-month, #reportes-perdida-hasta-month').val('');
			$('#reportes-perdida-desde-days, #reportes-perdida-hasta-days').val('');
			
			$('#reportes-perdida-desde-month, #reportes-perdida-hasta-month').hide();
			$('#reportes-perdida-desde-days, #reportes-perdida-hasta-days').show();
		}
	});
	$('#reportes-perdida-desde-month, #reportes-perdida-hasta-month').datepicker({
		language:'es',
		autoclose:true,
		format: "yyyy-mm", 
		startView: "months", 
		minViewMode: "months" 
	});
	var inicio_perdida_diario = $('#reportes-perdida-desde-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		autoclose:true
	}).on('changeDate', function (ev) {
			var newDate = new Date(ev.date);
			newDate.setDate(newDate.getDate());
			fin_perdida_diario.datepicker("update", newDate);
			$('#reportes-perdida-hasta-days')[0].focus();
	});
	var fin_perdida_diario = $('#reportes-perdida-hasta-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		beforeShowDay: function (date) {
			if (!inicio_perdida_diario.datepicker("getDate").valueOf()) {
				return date.valueOf() >= new Date().valueOf();
			} else {
				return date.valueOf() > inicio_perdida_diario.datepicker("getDate").valueOf()-1;
			}
		},
		autoclose: true

	}).on('changeDate', function (ev) {}); 
	
	/*Devolucion*/
	$("#construirGraficoDevolucion").on("click",function(){
		var valid = true;
		var fechadesde = "";
		var fechahasta = "";
		var valores = false;
		
		if($("#reportes-devolucion-mostrar").is(":checked")){
			valores = true;
		}
		
		if($('#reportes-devolucion-tipo').val()=='mensual'){
			if($('#reportes-devolucion-desde-month').val() == ""){
				$('#reportes-devolucion-desde-month').focus();
				valid = false;
			}else if($('#reportes-devolucion-hasta-month').val() == ""){
				$('#reportes-devolucion-hasta-month').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-devolucion-desde-month').val();
				fechahasta = $('#reportes-devolucion-hasta-month').val();
			}
		}else{
			if($('#reportes-devolucion-desde-days').val() == ""){
				$('#reportes-devolucion-desde-days').focus();
				valid = false;
			}else if($('#reportes-devolucion-hasta-days').val() == ""){
				$('#reportes-devolucion-hasta-days').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-devolucion-desde-days').val();
				fechahasta = $('#reportes-devolucion-hasta-days').val();
			}
		}
		if(valid){
			$.get('<?php echo base_url();?>reportes/grafico_salidas_devolucion?fechadesde='+fechadesde+'&fechahasta='+fechahasta+'&tipo='+$('#reportes-devolucion-tipo').val()+'&valores='+valores)
			.done(function(data){                
				$('.devolucion-ajax-content').html(data);
			});
		}else{
			toastr.options = {
			  "closeButton": true,
			  "progressBar": true,
			  "positionClass": "toast-top-right"
			}
			toastr.error('Hace falta informacion necesaria para enviar el formulario, favor verifique');
		}		
	});
	
	$('#reportes-devolucion-tipo').change(function(){
		if($(this).val()=='mensual'){
			$('#reportes-devolucion-desde-month, #reportes-devolucion-hasta-month').val('');
			$('#reportes-devolucion-desde-days, #reportes-devolucion-hasta-days').val('');
			
			$('#reportes-devolucion-desde-month, #reportes-devolucion-hasta-month').show();
			$('#reportes-devolucion-desde-days, #reportes-devolucion-hasta-days').hide();
		}else{
			$('#reportes-devolucion-desde-month, #reportes-devolucion-hasta-month').val('');
			$('#reportes-devolucion-desde-days, #reportes-devolucion-hasta-days').val('');
			
			$('#reportes-devolucion-desde-month, #reportes-devolucion-hasta-month').hide();
			$('#reportes-devolucion-desde-days, #reportes-devolucion-hasta-days').show();
		}
	});
	$('#reportes-devolucion-desde-month, #reportes-devolucion-hasta-month').datepicker({
		language:'es',
		autoclose:true,
		format: "yyyy-mm", 
		startView: "months", 
		minViewMode: "months" 
	});
	var inicio_devolucion_diario = $('#reportes-devolucion-desde-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		autoclose:true
	}).on('changeDate', function (ev) {
			var newDate = new Date(ev.date);
			newDate.setDate(newDate.getDate());
			fin_devolucion_diario.datepicker("update", newDate);
			$('#reportes-devolucion-hasta-days')[0].focus();
	});
	var fin_devolucion_diario = $('#reportes-devolucion-hasta-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		beforeShowDay: function (date) {
			if (!inicio_devolucion_diario.datepicker("getDate").valueOf()) {
				return date.valueOf() >= new Date().valueOf();
			} else {
				return date.valueOf() > inicio_devolucion_diario.datepicker("getDate").valueOf()-1;
			}
		},
		autoclose: true

	}).on('changeDate', function (ev) {}); 
	
	/*Consumo*/
	$("#construirGraficoConsumo").on("click",function(){
		var valid = true;
		var fechadesde = "";
		var fechahasta = "";
		var valores = false;
		
		if($("#reportes-consumo-mostrar").is(":checked")){
			valores = true;
		}
		
		if($('#reportes-consumo-tipo').val()=='mensual'){
			if($('#reportes-consumo-desde-month').val() == ""){
				$('#reportes-consumo-desde-month').focus();
				valid = false;
			}else if($('#reportes-consumo-hasta-month').val() == ""){
				$('#reportes-consumo-hasta-month').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-consumo-desde-month').val();
				fechahasta = $('#reportes-consumo-hasta-month').val();
			}
		}else{
			if($('#reportes-consumo-desde-days').val() == ""){
				$('#reportes-consumo-desde-days').focus();
				valid = false;
			}else if($('#reportes-consumo-hasta-days').val() == ""){
				$('#reportes-consumo-hasta-days').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-consumo-desde-days').val();
				fechahasta = $('#reportes-consumo-hasta-days').val();
			}
		}
		if(valid){
			$.get('<?php echo base_url();?>reportes/grafico_salidas_consumo?fechadesde='+fechadesde+'&fechahasta='+fechahasta+'&tipo='+$('#reportes-consumo-tipo').val()+'&valores='+valores)
			.done(function(data){                
				$('.consumo-ajax-content').html(data);
			});
		}else{
			toastr.options = {
			  "closeButton": true,
			  "progressBar": true,
			  "positionClass": "toast-top-right"
			}
			toastr.error('Hace falta informacion necesaria para enviar el formulario, favor verifique');
		}		
	});
	
	$('#reportes-consumo-tipo').change(function(){
		if($(this).val()=='mensual'){
			$('#reportes-consumo-desde-month, #reportes-consumo-hasta-month').val('');
			$('#reportes-consumo-desde-days, #reportes-consumo-hasta-days').val('');
			
			$('#reportes-consumo-desde-month, #reportes-consumo-hasta-month').show();
			$('#reportes-consumo-desde-days, #reportes-consumo-hasta-days').hide();
		}else{
			$('#reportes-consumo-desde-month, #reportes-consumo-hasta-month').val('');
			$('#reportes-consumo-desde-days, #reportes-consumo-hasta-days').val('');
			
			$('#reportes-consumo-desde-month, #reportes-consumo-hasta-month').hide();
			$('#reportes-consumo-desde-days, #reportes-consumo-hasta-days').show();
		}
	});
	$('#reportes-consumo-desde-month, #reportes-consumo-hasta-month').datepicker({
		language:'es',
		autoclose:true,
		format: "yyyy-mm", 
		startView: "months", 
		minViewMode: "months" 
	});
	var inicio_consumo_diario = $('#reportes-consumo-desde-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		autoclose:true
	}).on('changeDate', function (ev) {
			var newDate = new Date(ev.date);
			newDate.setDate(newDate.getDate());
			fin_consumo_diario.datepicker("update", newDate);
			$('#reportes-consumo-hasta-days')[0].focus();
	});
	var fin_consumo_diario = $('#reportes-consumo-hasta-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		beforeShowDay: function (date) {
			if (!inicio_consumo_diario.datepicker("getDate").valueOf()) {
				return date.valueOf() >= new Date().valueOf();
			} else {
				return date.valueOf() > inicio_consumo_diario.datepicker("getDate").valueOf()-1;
			}
		},
		autoclose: true

	}).on('changeDate', function (ev) {}); 
	
	// Radialize the colors
	Highcharts.getOptions().colors = Highcharts.map(Highcharts.getOptions().colors, function (color) {
		return {
			radialGradient: {
				cx: 0.5,
				cy: 0.3,
				r: 0.7
			},
			stops: [
				[0, color],
				[1, Highcharts.Color(color).brighten(-0.3).get('rgb')] // darken
			]
		};
	});
});
</script>