var Cotizaciones=function(){
	this.baseUrl=null;
	this.setUrl=function(url){
		this.baseUrl=url;
	}
	this.test=function(){
		console.log('La clase Cotizaciones ha sido instanciado correctamente');
	}
	this.cargarCotizaciones=function(){
		var tableCotizaciones = $('#cotizaciones-table').DataTable();
		tableCotizaciones.ajax.reload();
		setTimeout(function () { $('div.dataTables_filter input').focus(); }, 100);
	}
	this.guardar=function(e,action,id){
		e.preventDefault();
		var $sender = $(e.target);	
		$sender.attr('disabled','disabled');
		var _this=this;
		
		if($('#nueva-cotizacion-cliente').val()){
			if($("#nueva-cotizacion-productos-wrapper table tr").size()>0){
				var products=$("#nueva-cotizacion-productos-wrapper table tr");
				var totals=$("#nueva-cotizaciones-totales-wrapper tr");
				var productos=[];
				var totales=[];
				$.each(products,function(index,product){
					productos.push({id:$(product).attr('data-id'),pre:$(product).attr('data-pre'),uequiv:$(product).attr('data-uequiv'),desc:$(product).find('.table-desc').attr('data-value'),cant:$(product).find('.table-cant').attr('data-value'),costo:$(product).find('.table-precio').attr('data-value'),tipoventa:$(product).find('.table-tipoventa').attr('data-value')});
				});
				$.each(totals,function(index,total){
					switch($(total).attr('class')){
						case 'totalGrabadas':totales.push({totalGrabadas:$(total).find('.totalval').attr('data-value')});break;
						case 'totalIVAretenido':totales.push({totalIVAretenido:$(total).find('.totalval').attr('data-value')});break;
						case 'totalNS':totales.push({totalNS:$(total).find('.totalval').attr('data-value')});break;
						case 'totalExento':totales.push({totalExento:$(total).find('.totalval').attr('data-value')});break;
						case 'totalTotal':totales.push({totalTotal:$(total).find('.totalval').attr('data-value')});break;
					}
				});
				
				$.post(_this.baseUrl+'transacciones/guardarcotizacion', {
					action:action,
					id:id,
					cliente:$('#nueva-cotizacion-cliente').val(),
					fecha:$('#nueva-cotizacion-fecha').val(),
					notas:$('#nueva-cotizacion-notas').val(),
					firmante:$("#nueva-cotizacion-firmante").val(),
					productos:JSON.stringify(productos),
					totales:JSON.stringify(totales),
					preciosconiva: $("#nueva-cotizacion-preciosconiva").is(":checked"),
					precioscontrans: $("#nueva-cotizacion-precioscontrans").is(":checked"),
					firmacliente: $("#nueva-cotizacion-firmacliente").is(":checked"),
					chequebool: $("#nueva-cotizacion-chequebool").is(":checked"),
					chequetext: $("#nueva-cotizacion-chequetext").val(),
					validezbool: $("#nueva-cotizacion-validezbool").is(":checked"),
					valideztext: $("#nueva-cotizacion-valideztext").val(),
					observacionesbool: $("#nueva-cotizacion-observacionesbool").is(":checked"),
					observacionestext: $("#nueva-cotizacion-observacionestext").val(),
					garantiabool: $("#nueva-cotizacion-garantiabool").is(":checked"),
					garantiatext: $("#nueva-cotizacion-garantiatext").val(),
					fletebool: $("#nueva-cotizacion-fletebool").is(":checked"),
					fletetext: $("#nueva-cotizacion-fletetext").val(),
					formapagobool: $("#nueva-cotizacion-formapagobool").is(":checked"),
					formapagotext: $("#nueva-cotizacion-formapagotext").val(),
					periodobool: $("#nueva-cotizacion-periodobool").is(":checked"),
					periodotext: $("#nueva-cotizacion-periodotext").val(),
				}).done(function(responseText) {
					toastr.options = {
						"closeButton": true,
						"progressBar": true,
						"positionClass": "toast-top-right"
					}
					toastr.success('La cotizaci&oacute;n se ha guardado en la Base de Datos del Sistema');

					swal({
						title: "Exportar cotizaci&oacute;n",
						text: "&iquest;Desa exportar esta cotizaci&oacute;n?",
						html: true,
						type:'info',
						showCancelButton:true,
						cancelButtonText:'No exportar',
						closeOnConfirm: true
					},function(confirm){
						if(confirm){
							window.open(_this.baseUrl+'reportes/reporte_cotizacion?id='+responseText,'_blank');
						}
						Custombox.close();
						_this.cargarCotizaciones();
					});
				});
			}else{
				toastr.options = {
					"closeButton": true,
					"progressBar": true,
					"positionClass": "toast-top-right"
				}
				toastr['error']('No se han ingresado productos en la tabla de cotizaci&oacute;n.');
				$sender.removeAttr('disabled');
			}
		}else{
			toastr.options = {
				"closeButton": true,
				"progressBar": true,
				"positionClass": "toast-top-right"
			}
			toastr['error']('Debe seleccionar un cliente para guardar la cotizaci&oacute;n');
			$sender.removeAttr('disabled');
		}
	}
	this.modificar=function(id){
		var _this=this;
		Custombox.open({
            target:_this.baseUrl+"transacciones/cotizacion_nueva?id="+id,
            effect: 'fadein',
			overlayClose:false,
			complete:function(){
					$(".modal-body input:text").first().focus();
				}
        });
	}
	this.eliminar=function(id){
		var _this=this;
		swal({
		  title: "Eliminar cotizaci&oacute;n",
		  text: "La cotizaci&oacute;n No.:"+id+" se eliminar&aacute; definitivamente del sistema, &iquest;Desea continuar?",
		  html: true,
		  type: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#DD6B55",
		  cancelButtonText: "Cancelar",
		  confirmButtonText: "Si, Elimninar",
		},
		function(isconfirm){
			if(isconfirm){
				$.get(_this.baseUrl+'transacciones/eliminarcotizacion',{id:id},function(deleted){
					if(deleted){
						toastr.options = {
						  "closeButton": true,
						  "progressBar": true,
						  "positionClass": "toast-top-right"
						}
						toastr.success('La cotizaci&oacute;n No.<b>'+id+'</b> se ha eliminado.');
						_this.cargarCotizaciones();
					}
				},'text');
			}
		});
	}
	this.facturar=function(id){
		var _this=this;
		Custombox.open({
			target:_this.baseUrl+'transacciones/facturacionapp?cotizacion='+id, 
			effect: 'fadein',
			overlayClose:false,
			complete:function(){
				$(".modal-body input:text").first().focus();
			}
		});
	}
}
var cotizaciones = new Cotizaciones();