class Entradas_nueva_compra_view{
    constructor(url, winId){
        this.baseUrl = url;
        this.windowId = winId;

        this.toolsCompras = new Transaccionestools(this.baseUrl);
        this.NProdFormValidate = null;

        this.initializeUI();
        this.initializeListeners();
        this.initializeHotkeys();
    }
    initializeUI(){
        let _this = this;
        /** Transaction Tools Confif*/
        this.toolsCompras.setProductFrame($("#"+this.windowId+" #nueva-compra-producto-info"));
        this.toolsCompras.setProductTable($("#"+this.windowId+" #nueva-entrada-compra-productos-wrapper > table"));
        this.toolsCompras.setTotalTable($("#"+this.windowId+" #nueva-entrada-compra-totales-wrapper"));
        this.toolsCompras.SetTotalsProfile('grabadas,iva,subtotal,percepcion,nosujetas,exentas,total','subtotal|+|percepcion|+|nosujetas|+|exentas',true);
        
        /**Proveedores Chosen */
        $("#"+this.windowId+" #nueva-compra-proveedor").chosen({
            no_results_text: "No se encontro ningun resultado",
            allow_single_deselect: true
        }).change(function(){
            _this.totalProfile($("#"+_this.windowId+" #nueva-compra-documento option:selected").val(), $("#"+_this.windowId+" #nueva-compra-proveedor option:selected").attr("data-type"));
            setTimeout(function(){$("#"+_this.windowId+" #nueva-compra-documento-numero").focus()},500);
        });
        /**Fecha */
        $("#"+this.windowId+" #nueva-compra-fecha").datepicker({
            language:'es',
			format:'dd-mm-yyyy',
			autoclose:true
        }).on("changeDate", function(){
            $("#"+_this.windowId+" #nueva-compra-producto-sku").focus()
        });
        /** --------------------------- MODAL NUEVO PRODUCTO ---------------------------*/
        /**Validate Form */
        this.NProdFormValidate = $("#compra-nuevo-producto-form").validate({
            messages: {
                prodsku: "El SKU es requerido.",
                proddesc: "La descripci&oacute; es requerida.",
                produmedida: "Unidad de medida es requerida",
                prodprec1: {
                    required: "Un precio es requerido.",
                    number: "Ingrese un n&uacute;mero v&aacute;lido"
                }
            }
        });
        /**Chosen para grupos Nuevo producto*/
        $("#compra-nprod-grupo_producto").chosen({
            no_results_text: "No se encontro ningun resultado",
            allow_single_deselect: true
        }).change(function(){
            _this.cargarSubGrupos($(this).val(),null);
        });
        /*Chosen subgrupos*/
        $("#compra-nprod-subgrupo_producto").chosen({
            no_results_text: "No se encontro ningun resultado",
            allow_single_deselect: true
        }).change(function(){
            setTimeout(function(){ $("#"+_this.windowId+" #compra-nprod-precio1_producto").focus();},500);
        });
        $('.chosen-container').css({"width": "260px"});
    }
    initializeListeners(){
        let _this = this;
        /**BUTTON Buscar producto (CLICK)*/
        $("#"+this.windowId+" #compras-buscar-producto-btn").click(function(){
            Custombox.open({
                target:_this.baseUrl+"productos/buscarproductos?field=nueva-compra-producto-sku&enter=true",
                effect: 'fadein'
            });
        });
        /**BUTTON Agregar nuevo producto (CLICK)*/
        $("#"+this.windowId+" #compras-agregar-producto-btn").click(function(){
            _this.nuevoProductoModalOpen(false);
        });
        /**SELECT Elegir documento de compra (CHANGE)*/
        $("#"+this.windowId+" #nueva-compra-documento").on('change',function(){
            _this.totalProfile($(this).val(), $("#"+_this.windowId+" #nueva-compra-proveedor option:selected").attr("data-type"));
            $("#"+_this.windowId+" #nueva-compra-documento-numero").focus();
        });
        /** TEXTBOX Buscar informacion de SKU (KEYPRESS[ENTER]) */
        $("#"+this.windowId+" #nueva-compra-producto-sku").keypress(function(e) {
            if(e.which == 13) {
                e.preventDefault();
                _this.toolsCompras.getProductInfoBySKU('tipo_venta,descripcion,precios',$(this).val(),$("#"+_this.windowId+" #nueva-compra-producto-cant"),$("#"+_this.windowId+" #nueva-compra-nuevo-prod-txt"));
                $("#nueva-compra-producto-costo").val('');
            }
        });
        /**TEXTBOX Dispara nuevo producto cuando no existe SKU (FOCUS) */
        $("#"+this.windowId+" #nueva-compra-nuevo-prod-txt").focus(function(){
            _this.nuevoProductoModalOpen(true);
        });
        /**BUTTON Agregar producto a la tabla (CLICK)*/
        $("#"+this.windowId+" #nueva-compra-producto-agregar").click(function(e){
            _this.toolsCompras.addProductToTable('data:.frame-producto-id@data-id,data:.frame-presentacion-id@data-pre,data:.frame-unidades-representativas@data-uequiv,data:.frame-producto-precios@data-pventa,field:.frame-producto-sku@table-sku,field:.frame-producto-desc@table-desc,field:.frame-producto-cant@table-cant,field:.frame-producto-costo@table-costo,operation:.frame-producto-cant|*|.frame-producto-costo@table-total,translation:.frame-producto-tipoventa@table-tipoventa,command:remove@table-del');
        });
        /**BUTTON Quitar producto de la tabla (CLICK) */
        $("#"+this.windowId+" #nueva-entrada-compra-productos-wrapper").on('click','table tr td.table-del',function(){
            let tr = $(this).closest('tr');
            _this.toolsCompras.removeProductToTable($(tr));
        });
        /**BUTTON Guardar compra (CLICK) */
        $("#"+this.windowId+" #nueva-compra-productos-guardar-btn").click(function(){
            let $sender = $(this);
            $sender.attr('disabled','disabled');
            if($("#"+_this.windowId+" #nueva-entrada-compra-productos-wrapper table tr").size()>0){/*Verificar tabla de productos*/
                if($("#"+_this.windowId+" #nueva-compra-proveedor").val()){/*Verificar el proveedor*/
                    if($.trim($("#"+_this.windowId+" #nueva-compra-documento-numero").val())!=''){/*Verificar numero*/
                        if($("#"+_this.windowId+" #nueva-compra-condicion").val()=='1' && $("#"+_this.windowId+" #credito-compra").val()==''){/*Verificar credito*/
                            _this.setCredito($("#"+_this.windowId+" #nueva-compra-proveedor").val());
                            $sender.removeAttr('disabled');
                        }else{
                            /** */
                            swal({
                                title: 'Guardar compra',
                                text: '&iquest;Deseas guardar la compra de '+$("#"+_this.windowId+" #nueva-entrada-compra-productos-wrapper table tbody tr").size()+' items al '+$("#"+_this.windowId+" #nueva-compra-condicion option:selected").text()+' al proveedor "'+$("#"+_this.windowId+" #nueva-compra-proveedor option:selected").text()+'" con '+$("#"+_this.windowId+" #nueva-compra-documento option:selected").text()+' n&uacute;mero '+$("#"+_this.windowId+" #nueva-compra-documento-numero").val()+'?',
                                html: true,
                                type: 'info',
                                showCancelButton: true,
                                confirmButtonColor: '#3C8DBC',
                                confirmButtonText: 'Si, guardar compra',
                                cancelButtonText: 'No guardar nada'
                            },
                            function(isConfirm) {
                                if(isConfirm){
                                    _this.savePurchase();
                                }
                                else{
                                    $("#"+_this.windowId+" #credito-compra").val("");
					                $("#"+_this.windowId+" #ncredito-fecha-limite").val("");
                                    $sender.removeAttr('disabled');
                                }
                            });
                        }
                    }else{
                        _this.showMsg('error','No se ha ingresado el numero de documento de compra');
                        $("#"+_this.windowId+" #nueva-compra-documento-numero").focus();
					    $sender.removeAttr('disabled');
                    }
                }else{
                    _this.showMsg('error','Debe seleccionar un proveedor para registrar la compra');
				    $sender.removeAttr('disabled');
                }
            }else{
                _this.showMsg('error','No se han ingresado productos en la tabla de compras.');
                $sender.removeAttr('disabled');
                $("#"+_this.windowId+" #nueva-compra-producto-sku").focus();
            }
        });
        /** --------------------------- MODAL NUEVO PRODUCTO ---------------------------*/
        /** ---------------------------------------------------------------------------*/
        /**MODAL abrir modal nuevo producto (SHOW) */
        $("#"+this.windowId+" #nueva-compra-nproducto-modal").on('shown.bs.modal', function () {
            $("#"+_this.windowId+" #nueva-compra-nproducto-modal #compra-nprod-sku_producto").val($("#"+_this.windowId+" #nueva-compra-producto-sku").val());
            if($("#"+_this.windowId+" #nueva-compra-producto-sku").val() != ""){
                $("#"+_this.windowId+" #nueva-compra-nproducto-modal #compra-nprod-desc_producto").trigger('focus');
            }else{
                $("#"+_this.windowId+" #nueva-compra-nproducto-modal #compra-nprod-sku_producto").trigger('focus');
            }
        });
        /**TEXTBOX Verificar SKU (BLUR) */
        $("#"+this.windowId+" #nueva-compra-nproducto-modal #compra-nprod-sku_producto").on('blur',function(event){
            var veriSKU = _this.verificarCodigo("sku",$.trim($(this).val()));
            if(veriSKU != null){
                if(parseInt(veriSKU.used)){
                    $("#"+_this.windowId+" #nueva-compra-nproducto-modal #compra-nprod-sku-msg").html('SKU Repetido, por favor ingrese otro - El SKU ingresado pertenece a <b>'+ veriSKU.prod+'</b>');
                }else{
                    $("#"+_this.windowId+" #nueva-compra-nproducto-modal #compra-nprod-sku-msg").empty();
                }
            }
            else{
                $("#"+_this.windowId+" #nueva-compra-nproducto-modal #compra-nprod-sku-msg").empty();
            }
        });
        /**BUTTON Asignar SKU (CLICK) */
        $("#"+this.windowId+" #compra-nprod-colocar-sku-auto").click(function(e){
            var func=$(this).attr("data-func");
            /*Colocar SKU Automatico*/
            if(func=="set"){
                var autoSKU="";
                /*Consultar correlativo de SKU automaticos*/
                jQuery.ajaxSetup({async:false});
                $.get(_this.baseUrl+"productos/autosku",{},function(sku){
                    if(sku!=0){
                        autoSKU=_this.zeroFill(sku,4);
                    }else{
                        alert("Ha ocurrido un problema al colocar el SKU, contacte a soporte tecnico");
                    }
                },"text");
                jQuery.ajaxSetup({async:true});
                if(autoSKU!=""){
                    /*Verificar duplicidad de SKU automatico obtenido*/
                    do{
                        var usedSKU = _this.verificarCodigo("sku",autoSKU);
                        if(usedSKU.used){
                            autoSKU = parseInt(autoSKU)+1;
                            autoSKU = _this.zeroFill(autoSKU,4);
                        }
                    }
                    while(usedSKU.used);
                    /*Colocar SKU*/
                    $("#"+_this.windowId+" #compra-nprod-sku_producto").val(autoSKU);
                    $("#"+_this.windowId+" #compra-nprod-sku_auto").val(1);
                    $("#"+_this.windowId+" #compra-nprod-sku_producto").prop("readonly","true");
                    $(this).attr("data-func","unset");
                    $(this).text("Quitar");
                    $(this).removeClass("btn-info");
                    $(this).addClass("btn-danger");
                    $("#"+_this.windowId+" #compra-nprod-desc_producto").focus();
                }
            }
            /*Quitar SKU Automatico*/
            else{
                $("#"+_this.windowId+" #compra-nprod-sku_producto").val("");
                $("#"+_this.windowId+" #compra-nprod-sku_auto").val(0);
                $("#"+_this.windowId+" #compra-nprod-sku_producto").removeAttr("readonly");
                $(this).attr("data-func","set");
                $(this).text("Asignar");
                $(this).removeClass("btn-danger");
                $(this).addClass("btn-info");
                $(this).focus();
            }
        });
        /**BUTTON Cancelar crear producto (CLICK) */
        $("#"+this.windowId+" #compra-nprod-cancelar-btn").click(function(){
            _this.resetNProdForm();
            $("#"+_this.windowId+" #nueva-compra-nproducto-modal").modal('hide');
        });
        /**BUTTON Guardar producto (CLICK) */
        $("#"+this.windowId+" #compra-nprod-guardar-btn").click(function(){
            $(this).prop('disabled',true);
            if($("#"+_this.windowId+" #compra-nuevo-producto-form").valid()){
                var grupo = $("#"+_this.windowId+" #compra-nprod-grupo_producto").val();
                var subgrupo = $("#"+_this.windowId+" #compra-nprod-subgrupo_producto").val();
                var presentaciones=[];
                presentaciones.push({
                    sku:$("#"+_this.windowId+" #compra-nprod-sku_producto").val(),
                    ref:$("#"+_this.windowId+" #compra-nprod-sku_producto").val(),
                    pre:"",
                    desc:$("#"+_this.windowId+" #compra-nprod-desc_producto").val(),
                    uquiv:1,
                    pp1:null, p1:$("#"+_this.windowId+" #compra-nprod-precio1_producto").val(), p1cma:0, p1cmi:0,
                    pp2:null, p2:($("#"+_this.windowId+" #compra-nprod-precio2_producto").val() != '' ? $("#"+_this.windowId+" #compra-nprod-precio2_producto").val() : null), p2au:false, p2cma:0, p2cmi:0,
                    pp3:null, p3:($("#"+_this.windowId+" #compra-nprod-precio3_producto").val() != '' ? $("#"+_this.windowId+" #compra-nprod-precio3_producto").val() : null), p3au:false, p3cma:0, p3cmi:0,
                    pp4:null, p4:null, p4au:false, p4cma:0, p4cmi:0,
                    pp5:null, p5:null, p5au:false, p5cma:0, p5cmi:0,
                    tipo:0
                });
                var data = {
                    id_producto: null,
                    id_presentacion: null,
                    sku_auto: $("#"+_this.windowId+" #compra-nprod-sku_auto").val(),
                    presentaciones_producto: JSON.stringify(presentaciones),
                    umedida_producto: $("#"+_this.windowId+" #compra-nprod-umedida_producto").val(),
                    id_grupo: (grupo != "" ? grupo : null),
                    id_sub_grupo: (subgrupo != "" ? subgrupo : null),
                    tipo_venta_producto: 0,
                    exist_min_producto: 0,
                    exist_max_producto: null,
                    info_producto: null,
                    imagen_producto: null,
                    existencia_sistema: '',
                    existencia_fisica: '',
                    transaccion_costo_uni: '',
                    tipo_transaccion: ''
                }
                $.post(_this.baseUrl+"productos/guardar_producto", data,function(response){
                    response = response.split('‡');
                    let resProdId = response[1];
                    if(resProdId && resProdId != ""){
                        $("#"+_this.windowId+" #nueva-compra-producto-sku").val($("#"+_this.windowId+" #compra-nprod-sku_producto").val());
                        _this.resetNProdForm();
                        /**simular enter */
                        var e = jQuery.Event("keypress");
                        e.which = 13;
                        e.keyCode = 13;
                        $("#"+_this.windowId+" #nueva-compra-producto-sku").trigger(e);
                        /** */
                        $("#"+_this.windowId+" #nueva-compra-nproducto-modal").modal('hide');
                    }
                },'text');
            }
            else{
                $(this).removeAttr('disabled');
            }
        });
    }
    /**------------ HOTKEYS ------------ */
    initializeHotkeys(){
        let _this =  this;
        /** TEXTBOX documento: foco en sku ENTER*/
        $("#"+this.windowId+" #nueva-compra-documento-numero").bind("keyup","return",function(e){
            $("#"+_this.windowId+" #nueva-compra-fecha").focus();
            //$("#"+_this.windowId+" #nueva-compra-producto-sku").focus();
        });
        /** TEXTBOX cant: foco en costo ENTER*/
        $("#"+this.windowId+" #nueva-compra-producto-cant").bind("keyup","return",function(e){
            $("#"+_this.windowId+" #nueva-compra-producto-costo").focus();
        });
        /** TEXTBOX costo: Agregar item ENTER*/
        $("#"+this.windowId+" #nueva-compra-producto-costo").bind("keyup","return",function(e){
            $("#"+_this.windowId+" #nueva-compra-producto-agregar").trigger("click");
        });
        /*TEXTBOX Buscar producto (F2)*/
		$("#"+this.windowId+" .form-control").bind("keydown", "f2", function(e){
			if($("#"+_this.windowId).is(":visible")){
				e.preventDefault();
				$("#"+_this.windowId+" #compras-buscar-producto-btn").trigger("click");
			}
		});
        /*DOCUMENT Buscar producto (F2)*/
		$(document).bind('keydown', 'f2', function(e){
			if($("#"+_this.windowId).is(":visible")){
				e.preventDefault();
				$("#"+_this.windowId+" #compras-buscar-producto-btn").trigger("click");
			}
		});
        /*DOCUMENT guardar venta (F10)*/
		$(document).bind('keydown', 'f10', function(e){
			if($("#"+_this.windowId).is(":visible")){
				e.preventDefault();
				$("#"+_this.windowId+" #nueva-compra-productos-guardar-btn").trigger('click');
			}
		});
        
		/*TEXTBOXguardar venta (F10)*/
		$("#"+this.windowId+" .form-control").bind('keydown', 'f10', function(e){
			if($("#"+_this.windowId).is(":visible")){
				e.preventDefault();
				$("#"+_this.windowId+" #nueva-compra-productos-guardar-btn").trigger('click');
			}
		});
        /** --------------------------- MODAL NUEVO PRODUCTO ---------------------------*/
        /** ---------------------------------------------------------------------------*/
        /**TEXTBOX SKU (ENTER) */
        $("#"+this.windowId+" #compra-nprod-sku_producto").bind("keyup","return",function(e){
            if($("#"+_this.windowId+" #nueva-compra-nproducto-modal").is(":visible")){
                $("#"+_this.windowId+" #compra-nprod-desc_producto").focus();
            }
        });
        /**TEXTBOX Descripcion (ENTER) */
        $("#"+this.windowId+" #compra-nprod-desc_producto").bind("keyup","return",function(e){
            if($("#"+_this.windowId+" #nueva-compra-nproducto-modal").is(":visible")){
                $("#"+_this.windowId+" #compra-nprod-umedida_producto").focus();
            }
        });
        /**TEXTBOX Unidad medida (ENTER) */
        $("#"+this.windowId+" #compra-nprod-umedida_producto").bind("keyup","return",function(e){
            if($("#"+_this.windowId+" #nueva-compra-nproducto-modal").is(":visible")){
                $("#"+_this.windowId+" #compra-nprod-precio1_producto").focus();
            }
        });
        /**TEXTBOX Precio 1 (ENTER) */
        $("#"+this.windowId+" #compra-nprod-precio1_producto").bind("keyup","return",function(e){
            if($("#"+_this.windowId+" #nueva-compra-nproducto-modal").is(":visible")){
                $("#"+_this.windowId+" #compra-nprod-precio2_producto").focus();
            }
        });
        /**TEXTBOX Precio 2 (ENTER) */
        $("#"+this.windowId+" #compra-nprod-precio2_producto").bind("keyup","return",function(e){
            if($("#"+_this.windowId+" #nueva-compra-nproducto-modal").is(":visible")){
                $("#"+_this.windowId+" #compra-nprod-precio3_producto").focus();
            }
        });
        /**TEXTBOX Precio 3 (ENTER) */
        $("#"+this.windowId+" #compra-nprod-precio3_producto").bind("keyup","return",function(e){
            if($("#"+_this.windowId+" #nueva-compra-nproducto-modal").is(":visible")){
                $("#"+_this.windowId+" #compra-nprod-guardar-btn").trigger("click");
            }
        });
    }
    /**------------ FUNCTIONES ------------ */
    /**FUNCION: Crea el perfil de precios para cada combinacion de proveedor y documento*/
    totalProfile(docType, provCat){
        console.log(docType);
        docType = parseInt(docType);
        provCat = parseInt(provCat);
        let totalItems = "sumas,total";
        let totalOp = "sumas";
        switch(docType){
            case 0: case 4:/**CCF */
                if(provCat == 3){/**Gran Contribuyente*/
                    totalItems = "grabadas,iva,subtotal,percepcion,nosujetas,exentas,total";
                    totalOp = "subtotal|+|percepcion|+|nosujetas|+|exentas";
                }else{/**NO, otros, mediano contribuyente*/
                    totalItems = "grabadas,iva,subtotal,nosujetas,exentas,total";
                    totalOp = "subtotal|+|nosujetas|+|exentas";
                }
            break;
            case 1:/**Factura */
                if(provCat == 3){/**Gran Contribuyente*/
                    totalItems = "grabadas,nosujetas,exentas,percepcion,total";
                    totalOp = "grabadas|+|nosujetas|+|exentas|+|percepcion";
                }else{
                    totalItems = "grabadas,nosujetas,exentas,total";
                    totalOp = "grabadas|+|nosujetas|+|exentas";
                }
            break;
        }
        this.toolsCompras.SetTotalsProfile(totalItems,totalOp,true);
    }
    /**FUNCION: Abrir una modal de nuevo producto */
    nuevoProductoModalOpen(msg){
        if(msg){
            $("#"+this.windowId+" #nueva-compra-nproducto-modal #compra-nprod-msg").show();
        }else{
            $("#"+this.windowId+" #nueva-compra-nproducto-modal #compra-nprod-msg").hide();
            $("#"+this.windowId+" #nueva-compra-producto-sku").val("");
            $("#"+this.windowId+" #nueva-compra-producto-desc").val("");
            $("#"+this.windowId+" #nueva-compra-producto-cant").val("");
            $("#"+this.windowId+" #nueva-compra-producto-costo").val("");
        }
        $("#"+this.windowId+" #nueva-compra-nproducto-modal").modal("show");
    }
    /**FUNCION: Cargar subgrupos */
	cargarSubGrupos(grupo,selectedSubGroup){
		var _this=this;
		$("#"+this.windowId+" #compra-nprod-subgrupo_producto").find('option').remove().end().append('<option value=""></option>').val(0);
		if(grupo!=0 || grupo!=""){
			jQuery.ajaxSetup({async:false});
			$.getJSON(this.baseUrl+"productos/getSubgrupos",{id:grupo},function(subgrupos){
				if(subgrupos!=null){
					$.each(subgrupos,function(i,subgrupo){
						var selected="";
						if(selectedSubGroup!=null && subgrupo.id==selectedSubGroup){
							selected="selected";
						}
						$("#"+_this.windowId+" #compra-nprod-subgrupo_producto").append("<option value='"+subgrupo.id+"' "+selected+">"+subgrupo.nombre+"</option>");
					});
				}
			});
			jQuery.ajaxSetup({async:true});
		}
		$("#"+this.windowId+" #compra-nprod-subgrupo_producto").trigger("chosen:updated");
		if(selectedSubGroup==null){
			setTimeout(function(){$("#"+_this.windowId+" #compra-nprod-subgrupo_producto").trigger('chosen:open');},100);   
		}
	}
    /*FUNCION: Verificar si un SKU esta disponible*/
	verificarCodigo(param,codigo){
		var data=null;
		if(codigo!=""){
			var _this=this;
			jQuery.ajaxSetup({async:false});
			$.get(this.baseUrl+"productos/verificar_codigo",{param:param,code:codigo},function(response){
				data=response;
			},"json");
			jQuery.ajaxSetup({async:true});
		}
		return data;
	}
    /*FUNCION: Completar con ceros adelante hasta alcanzar la longitud dada*/
	zeroFill(str,maxLength){
		var zeroFillStr="";
		str=str.toString();
		if(str.length<maxLength){
			for(var i=0;i<maxLength-str.length;i++){
				zeroFillStr+="0";
			}
			zeroFillStr+=str;
		}else{
			zeroFillStr=str;
		}
		return zeroFillStr;
	}
    /**FUNCION: Reiniciar formulario de nuevo producto */
	resetNProdForm(){
		/**Limpiar campos */
        $("#"+this.windowId+" #compra-nprod-sku_producto").val("");
		$("#"+this.windowId+" #compra-nprod-desc_producto").val("");
        $("#"+this.windowId+" #compra-nprod-umedida_producto").val("");
        /**Reiniciar selects de linea */
        $("#"+this.windowId+" #compra-nprod-grupo_producto").val('').trigger('chosen:updated');
        $("#"+this.windowId+" #compra-nprod-subgrupo_producto").val('').trigger('chosen:updated');
        /**... */
		$("#"+this.windowId+" #compra-nprod-precio1_producto").val("");
		$("#"+this.windowId+" #compra-nprod-precio2_producto").val("");
		$("#"+this.windowId+" #compra-nprod-precio3_producto").val("");
		/**Reiniciar boton de asignar */
		$("#"+this.windowId+" #compra-nprod-sku_auto").val(0);
		$("#"+this.windowId+" #compra-nprod-sku_producto").removeAttr("readonly");
		$("#"+this.windowId+" #compra-nprod-colocar-sku-auto").attr("data-func","set");
		$("#"+this.windowId+" #compra-nprod-colocar-sku-auto").text("Asignar");
		$("#"+this.windowId+" #compra-nprod-colocar-sku-auto").removeClass("btn-danger");
		$("#"+this.windowId+" #compra-nprod-colocar-sku-auto").addClass("btn-info");
		/** */
		this.NProdFormValidate.resetForm();
		/**Quitar disabled */
		$("#"+this.windowId+" #compra-nprod-guardar-btn").removeAttr("disabled");
	}
    /**FUNCION: Abrir ventana para colocar informacion de nuevo credito */
    setCredito(id){
		Custombox.open({
			target:this.baseUrl+'proveedores/creditosxproveedormin?proveedor='+id, 
			effect: 'fadein',
			complete:function(){
				$(".modal-body input:text").first().focus();
			}
		});
	}
    /**FUNCION: Guardar compra*/
    savePurchase(){
        let _this = this;
        let data = {
            proveedor: $("#"+this.windowId+" #nueva-compra-proveedor").val(),
            condicion: $("#"+this.windowId+" #nueva-compra-condicion").val(),
            documento: $("#"+this.windowId+" #nueva-compra-documento").val(),
            numero: $("#"+this.windowId+" #nueva-compra-documento-numero").val(),
            fecha: $("#"+this.windowId+" #nueva-compra-fecha").val(),
            credito: $("#"+this.windowId+" #credito-compra").val(),
            fechacred: $("#"+this.windowId+" #ncredito-fecha-limite").val(),
            productos: null,
            totales: null
        };
        /**Productos */
        let productos = [];
        $("#"+this.windowId+" #nueva-entrada-compra-productos-wrapper table tr").each(function(i, producto){
            productos.push({
                id:             $(producto).attr('data-id'),
                id_presentacion:$(producto).attr('data-pre'),
                uequiv:         $(producto).attr('data-uequiv'),
                desc:           $(producto).find('.table-desc').attr('data-value'),
                cant:           $(producto).find('.table-cant').attr('data-value'),
                costo:          $(producto).find('.table-costo').attr('data-value'),
                tipoventa:      $(producto).find('.table-tipoventa').attr('data-value')
            });
        });
        data.productos = JSON.stringify(productos);
        /*Totales */
        let totalRow = "#"+this.windowId+" #nueva-entrada-compra-totales-wrapper tr";
        let totales = [{
            totalSumas: ($(totalRow + ".totalSumas").length ? $(totalRow + ".totalSumas").find('.totalval').attr('data-value') : null), 
            totalGrabadas: ($(totalRow + ".totalGrabadas").length ? $(totalRow + ".totalGrabadas").find('.totalval').attr('data-value') : null), 
            totalIVA: ($(totalRow + ".totalIVA").length ? $(totalRow + ".totalIVA").find('.totalval').attr('data-value') : null),  
            totalIVApercibido: ($(totalRow + ".totalIVApercibido").length ? $(totalRow + ".totalIVApercibido").find('.totalval').attr('data-value') : null),
            totalIVAretenido: ($(totalRow + ".totalIVAretenido").length ? $(totalRow + ".totalIVAretenido").find('.totalval').attr('data-value') : null), 
            totalSubtotal: ($(totalRow + ".totalSubtotal").length ? $(totalRow + ".totalSubtotal").find('.totalval').attr('data-value') : null), 
            totalNS: ($(totalRow + ".totalNS").length ? $(totalRow + ".totalNS").find('.totalval').attr('data-value') : null), 
            totalExento: ($(totalRow + ".totalExento").length ? $(totalRow + ".totalExento").find('.totalval').attr('data-value') : null), 
            totalTotal: ($(totalRow + ".totalTotal").length ? $(totalRow + ".totalTotal").find('.totalval').attr('data-value') : null)
        }];
        data.totales = JSON.stringify(totales);
        /**Enviar datos */
        $.post(this.baseUrl+'productos/guardarcompra', data).done(function(response) {
			 /*$("#"+_this.windowId+" #nueva-compra-precios-wrapper").html(reponse); */
             if(response){
                _this.showMsg("success", "La compra se ha guardado con ID: <b>C-"+response+"</b>" );
             }else{
                alert("Error al guardar compra, intentelo de nuevo");
             }
            Custombox.close();
		});
    }
    /**FUNCION: Mostrar mensaje en pantalla */
    showMsg(tipo, mensaje){
		toastr.options = {
			"closeButton": true,
			"progressBar": true,
			"positionClass": "toast-top-right"
		}
		toastr[tipo](mensaje);
	}
}