var Lineas = function(){
	this.baseUrl=null;
	this.editMode=false;
	this.setUrl=function(url){
		this.baseUrl=url;
	}
	this.cargar=function(){
		var _this=this;
		$("#lineas-wrapper").html("");
		this.loader($("#lineas-wrapper"),'start');
		$.get(this.baseUrl+'productos/cargarlineas',{},function(lineas){
			if(lineas){
				$.each(lineas,function(i,linea){
					var subgrupos="";
					$.each(linea.subgrupos,function(index,subgrupo){
						if(index==0){liclass="fist-item";}else{liclass="";}
						subgrupos+="<li class='list-group-item "+liclass+"' data-id-subgrupo='"+subgrupo.id_subgrupo+"'>";
						subgrupos+="<span class='subgrupo'>"+subgrupo.nombre_subgrupo+"</span>"; 
						subgrupos+="<button class='btn btn-xs pull-right eliminar-subgrupo-btn'><i class='fa fa-times'></i></button>";
						subgrupos+="<button class='btn btn-xs pull-right m-r-xs editar-subgrupo-btn'><i class='fa fa-pencil'></i></button>"; 
						subgrupos+="<div class='clearfix'></div>";
						subgrupos+="</li>";
					});
					var htmllinea="<div class='panel panel-default'>";
					htmllinea+="<div class='panel-heading clearfix' data-group-id='"+linea.id_grupo+"'>";
					htmllinea+="<h5 class='panel-title pull-left'><a data-toggle='collapse' data-parent='#lineas-wrapper' href='#linea-"+linea.id_grupo+"'>"+linea.nombre_grupo+"</a></h5>";
					htmllinea+="<div class='btn-group pull-right'><button type='button' class='btn btn-xs editar-grupo-btn'><i class='fa fa-pencil'></i></button><button class='btn btn-xs m-r-xs eliminar-grupo-btn'><i class='fa fa-times'></i></button></div>";
					htmllinea+="</div>";
					htmllinea+="<div id='linea-"+linea.id_grupo+"' class='panel-collapse collapse'>";
					htmllinea+="<div class='panel-body'>";
					htmllinea+="<ul class='list-group clear-list' style='margin:0px'>";
					htmllinea+=subgrupos;
					htmllinea+="<li class='list-group-item linea-agregar-subgrupo'><button type='button' class='btn btn-sm btn-white'><i class='fa fa-plus-circle'></i> Agregar subgrupo</button></li>";
					htmllinea+="</ul>";
					htmllinea+="</div>";
					htmllinea+="</div>";
					htmllinea+="</div>";
					$("#lineas-wrapper").append(htmllinea);
					if(i+1==lineas.length){
						_this.loader($("#lineas-wrapper"),'stop');
					}
				});
			}else{
					$("#lineas-wrapper").append("<div class='text-center'><span>No se han encontrado lineas de productos.</span><div>");
					_this.loader($("#lineas-wrapper"),'stop');
				}
		},"json");
	}
	this.agregarSubgrupo=function($item){
		if(!this.editMode){
			this.editMode=true;
			$item.find('*').hide();
			var htmlInput="<div class='input-group'><input type='text' class='form-control nuevo-subgrupo-txt'><span class='input-group-btn'><button class='btn btn-white guardar-subgrupo-btn'><i class='fa fa-check'></i></button><button class='btn btn-white cancel-nuevo-subgrupo-btn'><i class='fa fa-times'></i></button></span></div>";
			$item.append(htmlInput);
			$item.find('.nuevo-subgrupo-txt').focus();
		}
	}
	this.cancelarNuevoSubgrupo=function($item){
			if(this.editMode){
			this.editMode=false;
			$item.find('*:visible').remove();
			$item.find('*').show();
		}
	}
	this.guardarNuevoSubgrupo=function($subgrupo,parent){
		var _this=this;
		var nombre=$subgrupo.find('.nuevo-subgrupo-txt').val();
		$.get(this.baseUrl+'productos/guardarsubgrupo',{subgrupo:nombre,grupo:parent},function(grupoID){
			$subgrupo.find('*:visible').remove();
			$subgrupo.find('*').show();
			var item="<li class='list-group-item fist-item' data-id-subgrupo='"+grupoID+"'><span class='subgrupo'>"+nombre+"</span><button class='btn btn-xs pull-right eliminar-subgrupo-btn'><i class='fa fa-times'></i></button><button class='btn btn-xs pull-right m-r-xs editar-subgrupo-btn'><i class='fa fa-pencil'></i></button></li>";
			$(item).insertBefore('.linea-agregar-subgrupo');
			_this.editMode=false;
		});
	}
	this.editarGrupo=function($grupo){
		if(!this.editMode){
			this.editMode=true;
			var $header=$grupo.find('.panel-heading');
			$header.find('*').hide();
			var htmlInput="<div class='input-group'><input type='text' class='form-control editar-grupo-txt' value='"+$header.find('.panel-title a').text()+"'><span class='input-group-btn'><button class='btn btn-white update-linea-btn'><i class='fa fa-check'></i></button><button class='btn btn-white cancel-edit-btn'><i class='fa fa-times'></i></button></span></div>";
			$header.append(htmlInput);
			$header.find('.editar-grupo-txt').focus();
		}
	}
	this.cancelarEditarGrupo=function($grupo){
		if(this.editMode){
			this.editMode=false;
			var $header=$grupo.find('.panel-heading');
			$header.find('*:visible').remove();
			$header.find('*').show();
		}
	}
	this.editarSubgrupo=function($subgrupo){
		if(!this.editMode){
			this.editMode=true;
			$subgrupo.find('*').hide();
			var htmlInput="<div class='input-group'><input type='text' class='form-control editar-subgrupo-txt' value='"+$subgrupo.find('span').text()+"'><span class='input-group-btn'><button class='btn btn-white update-subgrupo-btn'><i class='fa fa-check'></i></button><button class='btn btn-white cancel-edit-subgrupo-btn'><i class='fa fa-times'></i></button></span></div>";
			$subgrupo.append(htmlInput);
			$subgrupo.find('.editar-subgrupo-txt').focus();
		}
	}
	this.cancelarEditarSubgrupo=function($subgrupo){
		if(this.editMode){
			this.editMode=false;
			$subgrupo.find('*:visible').remove();
			$subgrupo.find('*').show();
		}
	}
	this.actualizarLinea=function(table,$textbox,id){
		var _this=this;
		var val=$textbox.val();
		$.get(this.baseUrl+'productos/editarlinea',{tabla:table,id:id,value:val},function(response){
			if(response==1){
				if(table=='grupos'){
					$item=$textbox.closest('.panel-heading');
					$item.find('.panel-title a').text(val);
				}else if(table=='subgrupos'){
					$item=$textbox.closest('li');
					$item.find('span.subgrupo').text(val)
				}
				$item.find('*:visible').remove();
				$item.find('*').show();
				_this.editMode=false;
			}
		},'text');
	}
	this.eliminarGrupo=function($grupo){
		var _this=this;
		var nombre= $grupo.find('.panel-title a').text();
		var id= $grupo.find('.panel-heading').attr('data-group-id');
		swal({
		  title: "¿Eliminar linea "+nombre+"?",
		  text: "Esta acción eliminará definitivamente la linea. ¿Esta seguro que desea continuar?",
		  type: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#DD6B55",
		  cancelButtonText: "Cancelar",
		  confirmButtonText: "Si, Eliminar"
		},
		function(){
			$.get(_this.baseUrl+"productos/eliminargrupo",{id:id},function(deleted){
				if(deleted){
					$grupo.remove(); 
					 toastr.options = {
					  "closeButton": true,
					  "progressBar": true,
					  "positionClass": "toast-top-right"
					}
					toastr.success('La linea <b>'+nombre+'</b> se ha eliminado.');
				}
			},'text');
		});
	}
	this.eliminarSubgrupo=function($subgrupo){
		var _this=this;
		var nombre= $subgrupo.find('span.subgrupo').text();
		var id= $subgrupo.attr('data-id-subgrupo');
		swal({
		  title: "¿Eliminar subgrupo "+nombre+"?",
		  text: "Esta acción eliminará definitivamente este subgrupo. ¿Esta seguro que desea continuar?",
		  type: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#DD6B55",
		  cancelButtonText: "Cancelar",
		  confirmButtonText: "Si, Eliminar"
		},
		function(){
			$.get(_this.baseUrl+"productos/eliminarsubgrupo",{id:id},function(deleted){
				if(deleted){
					$subgrupo.remove(); 
					 toastr.options = {
					  "closeButton": true,
					  "progressBar": true,
					  "positionClass": "toast-top-right"
					}
					toastr.success('El grupo <b>'+nombre+'</b> se ha eliminado.');
				}
			},'text');
		});
	}
	this.loader=function($wrapper,action){
		if(action=='start'){
			var load=$(document.createElement('div')).attr('class','sk-spinner sk-spinner-fading-circle');
			for(var i=1; i<=12; i++){
				$(document.createElement('div')).attr('class','sk-circle'+i+' sk-circle').appendTo(load);
			}
			load.appendTo($wrapper);
		}else if('stop'){
			$wrapper.find('.sk-spinner').remove();
		}
	}
}
var lineas = new Lineas();