var Productos_inventario_nuevo_producto=function(){
	this.baseUrl=null;
	this.windowId=null;
	this.selfSKU = "";
	this.initializeEnviroment=function(url,winId){
		this.baseUrl=url;
		this.windowId=winId;
		this.initializeGUIComponets();
		this.initializeListeners();
	},
	this.test=function(){
		console.log("La clase Productos_inventario_nuevo_producto se ha instanseado desde: "+this.baseUrl, " en la ventana: "+this.windowId);
	},
	/*Inicializar componentes de la interfaz*/
	this.initializeGUIComponets=function(){
		var _this=this;
		/*Scroll contenedor de presentaciones*/
		$("#"+this.windowId+" #nuevo-producto-presentaciones-wrapper").slimScroll({height: '244px'});
		/*Chosen grupos*/
		$("#"+this.windowId+" #id_grupo").chosen({
			no_results_text: "No se encontro ningun resultado",
			allow_single_deselect: true
		}).change(function(){
			_this.cargarSubGrupos($(this).val(),null);
		});
		/*Chosen subgrupos*/
		$("#"+this.windowId+" #id_sub_grupo").chosen({
			no_results_text: "No se encontro ningun resultado",
			allow_single_deselect: true
		});
		/*Desabilitar ajuste de inventario para nuevos productos*/
		if($("#"+this.windowId+" #nuevo-producto-existencias-sistema").val()==""){
			$("#"+this.windowId+" #nuevo-producto-existencias-transaccion-ajuste").removeAttr("checked");
			$("#"+this.windowId+" #nuevo-producto-existencias-transaccion-ajuste").prop("disabled","disabled");
			$("#"+this.windowId+" #nuevo-producto-existencias-transaccion-inicial").prop("checked","checked");
		}
	},
	/*EVENTOS*/
	this.initializeListeners=function(){
		var _this=this;
		/*TEXTBOX enter para cambiar a siguiene campo (keyup)*/
		$("#"+this.windowId+" #sku_producto").on('keyup', function(event){
			var keycode=(event.keyCode?event.keyCode:event.which);
			if(keycode=='13'){
				$("#"+_this.windowId+" #desc_producto").focus();
			}
		});
		/*TEXTBOX Verificar si el SKU ha sido asignado (focusout)*/
		$("#"+this.windowId+" #sku_producto").on('focusout',function(){
			var idpre = $("#"+_this.windowId+" #id_presentacion").val();
			var veriSKU=_this.verificarSKU($.trim($(this).val()),idpre);
			if(veriSKU!=null){
				if(parseInt(veriSKU.used)){
					$("#"+_this.windowId+" .productExist").css('color','#FF0000').html('SKU Repetido, ingrese otro - El SKU ingresado pertenece a <b>'+ veriSKU.prod+'</b>');
				}else{
					$("#"+_this.windowId+" .productExist").empty();
				}
			}
			else{
				$("#"+_this.windowId+" .productExist").empty();
			}
		});
		/*BOTON Asignar un sku automatico (CLICK)*/
		$("#"+this.windowId+" #colocar-sku-auto").on('click',function(event){
			var func=$(this).attr("data-func");
			/*Colocar SKU Automatico*/
			if(func=="set"){
				var autoSKU="";
				/*Consultar correlativo de SKU automaticos*/
				jQuery.ajaxSetup({async:false});
				$.get(_this.baseUrl+"productos/autosku",{},function(sku){
					if(sku!=0){
						autoSKU=_this.zeroFill(sku,4);
					}else{
						alert("Ha ocurrido un problema al colocar el SKU, contacte a soporte tecnico");
					}
				},"text");
				jQuery.ajaxSetup({async:true});
				if(autoSKU!=""){
					/*Verificar duplicidad de SKU automatico obtenido*/
					/* do{
						var usedSKU=_this.verificarSKU(autoSKU);
						if(usedSKU.used){
							autoSKU=parseInt(autoSKU)+1;
							autoSKU=_this.zeroFill(autoSKU,4);
						}
					}
					while(usedSKU.used); */
					/*Colocar SKU*/
					$("#"+_this.windowId+" #sku_producto").val(autoSKU);
					$("#"+_this.windowId+" #sku_auto").val(1);
					$("#"+_this.windowId+" #sku_producto").prop("readonly","true");
					$(this).attr("data-func","unset");
					$(this).text("Quitar");
					$(this).removeClass("btn-info");
					$(this).addClass("btn-danger");
				}
			}
			/*Quitar SKU Automatico*/
			else{
				$("#"+_this.windowId+" #sku_producto").val("");
				$("#"+_this.windowId+" #sku_auto").val(0);
				$("#"+_this.windowId+" #sku_producto").removeAttr("readonly");
				$(this).attr("data-func","set");
				$(this).text("Asignar");
				$(this).removeClass("btn-danger");
				$(this).addClass("btn-info");
				$(this).focus();
			}
		});
		/*DIV Click en mascara para agregar imagen a producto*/
		$("#"+this.windowId+" #nuevo-producto-img-change-mask").click(function(){
			$("#"+_this.windowId+" #nuevo-producto-img-file").trigger("click");
		});
		/*FILE abrir explorador de archivos (CLICK)*/
		$("#"+this.windowId+" #nuevo-producto-img-file").change(function(){
			if (window.FileReader) {
				var fileReader = new FileReader(),files=this.files,file;
				if(!files.length){
					return;
				}
				file=files[0];
				if(/^image\/\w+$/.test(file.type)){
					fileReader.readAsDataURL(file);
					fileReader.onload=function(e){
						$("#"+_this.windowId+" #nuevo-producto-img").attr("src",fileReader.result);
					}
				}
				else{
					_this.showMsg("error","Debe seleccionar una imagen con formato v&aacute;lido");
				}
			}
		});
		/*TEXTBOX existencias fisicas (KEYUP)*/
		$("#"+this.windowId+" #nuevo-producto-existencias-fisica").keyup(function(e){
			if($.trim($(this).val())!=""){
				if($("#"+_this.windowId+" #nuevo-producto-existencias-transaccion-ajuste").is(":checked")){
					_this.transAjusteInventario("set");
				}
			}else{
				console.log("unset");
				 _this.transAjusteInventario("unset");
			}
		});
		/*RADIO seleccionar inventario inicial(CHANGE)*/
		$("#"+this.windowId+" #nuevo-producto-existencias-transaccion-inicial").change(function(){
			if($(this).is(":checked"))
				_this.transAjusteInventario("unset");
		});
		/*RADIO seleccionar ajuste de inventario (CHANGE)*/
		$("#"+this.windowId+" #nuevo-producto-existencias-transaccion-ajuste").change(function(){
			if($(this).is(":checked"))
				_this.transAjusteInventario("set");
		});
		/*BUTTON Guardar nuevo producto (CLICK)*/
		$("#"+this.windowId+" #nuevo-producto-guardar-btn").click(function(){
			$(this).attr('disabled','disabled');
			var form = $("#nproducto-form");
			/*Validar inputs*/
			var valid=true;
			$.each(form.find($("input, select")),function(i,el){
				$el=$(el);
				if($el.attr("data-requiredfield")==="required" && !$el.is(":disabled")){
					switch($el.prop("tagName")){
						case "INPUT":
							switch($el.attr("type")){
								case "text": case "number": case "password": /*textbox*/
									if($el.val()===""){
										valid=false;
										_this.showMsg('error', 'Ingrese un valor v&aacute;lido para el campo');
										/*toastr.options = {
										"closeButton": true,
										"progressBar": true,
										"positionClass": "toast-top-right"
										}
										toastr.error();*/
										$el.focus();
									}
								break;
							}
						break;
					}
				}
				return valid;
			});
			/*Validar sku unico*/
			if(valid){
				var sku = $.trim($("#"+_this.windowId+" #sku_producto").val());
				var idpre = $("#"+_this.windowId+" #id_presentacion").val();
				var veriSKU=_this.verificarSKU(sku,idpre);
				if(veriSKU.used){
					valid = false;
					_this.showMsg('error', 'El SKU <b>'+sku+'</b> ya esta registrado para el producto <b>'+veriSKU.prod+'</b>');
					$("#"+_this.windowId+" #sku_producto").focus();
				}
			}
			/*Guardar*/
			if(valid){
				/*Serializar presentaciones*/
				var presentaciones=[];
				/*Presentaciones primarias*/
				presentaciones.push({
					sku:$("#sku_producto").val(),
					ref:$("#sku_producto").val(),
					pre:$("#id_presentacion").val(),
					desc:$("#desc_producto").val(),
					uquiv:1,
					pp1:null, p1:$("#precio1_producto").val(), p1cma:0, p1cmi:0,
					pp2:null, p2:($("#precio2_producto").val() != '' ? $("#precio2_producto").val() : null), p2au:false, p2cma:0, p2cmi:0,
					pp3:null, p3:($("#precio3_producto").val() != '' ? $("#precio3_producto").val() : null), p3au:false, p3cma:0, p3cmi:0,
					pp4:null, p4:($("#precio4_producto").val() != '' ? $("#precio4_producto").val() : null), p4au:false, p4cma:0, p4cmi:0,
					pp5:null, p5:($("#precio5_producto").val() != '' ? $("#precio5_producto").val() : null), p5au:false, p5cma:0, p5cmi:0,
					tipo:0
				});
				/*Presentaciones secundarias*/
				$('#nuevo-producto-presentaciones-wrapper > .nproducto-presentacion-item-wrapper').each(function(i,item){
					var $item=$(item);
					presentaciones.push({
						sku:$item.find('.nproducto-presentacion-item-sku').text(),
						ref:$item.find('.nproducto-presentacion-item-sku').text(),
						pre:$item.attr("data-presentacion"),
						desc:$item.find('.nproducto-presentacion-item-nombre').text(),
						uquiv:$item.find('.nproducto-presentacion-item-unidades i').text(),
						pp1:null,
						p1:$item.find('.nproducto-presentacion-item-precio1 i.data').text(), p1cma:0, p1cmi:0,
						pp2:null, p2:($item.find('.nproducto-presentacion-item-precio2 i.data').text() != '' ? $item.find('.nproducto-presentacion-item-precio2 i.data').text() : null), p2au:false, p2cma:0, p2cmi:0,
						pp3:null, p3:($item.find('.nproducto-presentacion-item-precio3 i.data').text() != '' ? $item.find('.nproducto-presentacion-item-precio3 i.data').text() : null), p3au:false, p3cma:0, p3cmi:0,
						pp4:null, p4:($item.find('.nproducto-presentacion-item-precio4 i.data').text() != '' ? $item.find('.nproducto-presentacion-item-precio4 i.data').text() : null), p4au:false, p4cma:0, p4cmi:0,
						pp5:null, p5:($item.find('.nproducto-presentacion-item-precio5 i.data').text() != '' ? $item.find('.nproducto-presentacion-item-precio5 i.data').text() : null), p5au:false, p5cma:0, p5cmi:0,
						tipo:1
					});
				});
				$("#presentaciones_producto").val(JSON.stringify(presentaciones));
				/*Opciones*/
				var options = {
					success:function(responseText){
						_this.showMsg('success', 'El Producto <b>'+responseText.split('‡')[0]+'</b> se ha '+$('#nuevo-producto-guardar-btn').attr('data-action')+' en la Base de Datos del Sistema');
						var tableInventario = $('#tableInventario').DataTable();
						tableInventario.ajax.reload();
						$('#producto-detalles').html("<div class='overlay'><i class='fa fa-refresh fa-spin' style='font-size:50px;margin-top:50px;'></i></div>");
						$.get(_this.baseUrl+'productos/ver_producto?id='+responseText.split('‡')[1])
						.done(function(data){                
							$('#producto-detalles').html(data);
						});
						Custombox.close();
					}
				};
				/*Guardar producto*/
				form.ajaxSubmit(options);
			}
			else{
				$(this).removeAttr('disabled');
			}

		});
	},
	/*FUNCIONES*/
	/*Verificar si un SKU esta en uso o no*/
	this.verificarSKU=function(sku,pre){
		if(sku!=""){
			if(this.selfSKU != "" && this.selfSKU == sku){
				data = {"used":0,"prod":NULL};
			}else{
				var _this=this;
				var data=null;
				jQuery.ajaxSetup({async:false});
				$.get(_this.baseUrl+"productos/searchProductSKU",{sku:sku,pre:pre},function(response){
					data=response;
				},"json");
			}
		}
		jQuery.ajaxSetup({async:true});
		return data;
	},
	/*Completar con ceros adelante hasta alcanzar la longitud dada*/
	this.zeroFill=function(str,maxLength){
		var zeroFillStr="";
		str=str.toString();
		if(str.length<maxLength){
			for(var i=0;i<maxLength-str.length;i++){
				zeroFillStr+="0";
			}
			zeroFillStr+=str;
		}else{
			zeroFillStr=str;
		}
		return zeroFillStr;
	},
	/*Cargar Subgrupos*/
	this.cargarSubGrupos=function(grupo,selectedSubGroup){
		var _this=this;
		$("#"+this.windowId+' #id_sub_grupo').find('option').remove().end().append('<option value=""></option>').val(0);
		if(grupo!=0 || grupo!=""){
			jQuery.ajaxSetup({async:false});
			$.getJSON(this.baseUrl+"productos/getSubgrupos",{id:grupo},function(subgrupos){
				if(subgrupos!=null){
					$.each(subgrupos,function(i,subgrupo){
						var selected="";
						if(selectedSubGroup!=null && subgrupo.id==selectedSubGroup){
							selected="selected";
						}
						$("#"+_this.windowId+" #id_sub_grupo").append("<option value='"+subgrupo.id+"' "+selected+">"+subgrupo.nombre+"</option>");
					});
				}
			});
			jQuery.ajaxSetup({async:true});
		}
		$("#"+this.windowId+" #id_sub_grupo").trigger("chosen:updated");
		if(selectedSubGroup==null){
			setTimeout(function(){$("#"+_this.windowId+" #id_sub_grupo").trigger('chosen:open');},100);   
		}
	},
	/*Calcular transaccion de ajuste de inventario*/
	this.transAjusteInventario=function(action){
		if(action=="set"){
			var existenciaFisica=$("#"+this.windowId+" #nuevo-producto-existencias-fisica").val();
			if(existenciaFisica!=""){
				var existenciaSistema=$("#"+this.windowId+" #nuevo-producto-existencias-sistema").val();
				if(existenciaSistema=="")
					existenciaSistema=0;
				/*calculo*/
				diferencia=parseFloat(existenciaFisica)-parseFloat(existenciaSistema);
				var msg="";
				switch(true){
					case diferencia<0:{
						diferencia=Math.abs(diferencia);
						msg="<b>Salida de "+diferencia+" unidades</b> en concepto de 'Ajuste de inventario' para alcanzar "+existenciaFisica+" unidades.";
					}break;
					case diferencia>0:{
						msg="<b>Entrada de "+diferencia+" unidades</b> en concepto de 'Ajuste de inventario' para alcanzar "+existenciaFisica+" unidades.";
					}break;
					case diferencia==0:{
						msg="No se realizará ninguna transaccion, las existencias coinciden";
					}break;
				}
				if(msg!=""){
					$("#"+this.windowId+" #nuevo-producto-existencias-trans-info-wrapper").html(msg);
					$("#"+this.windowId+" #nuevo-producto-existencias-trans-info-wrapper").show();
				}
			}
		}
		else{
			$("#"+this.windowId+" #nuevo-producto-existencias-trans-info-wrapper").html("");
			$("#"+this.windowId+" #nuevo-producto-existencias-trans-info-wrapper").hide();
		}
	},
	/*Mostrar mensaje*/
	this.showMsg=function(tipo,mensaje){
		toastr.options = {
			"closeButton":true,
			"progressBar":true,
			"positionClass":"toast-top-right"
		}
		toastr[tipo](mensaje);
	}
}