var Transaccionestools = function(url) {
    this.baseURL = url;
    this.ProductFrame = null;
    this.ProductTable = null;
    this.totalTable = null;
    this.AjustTotalFrame = null;
    this.Totals = {
        'sumas': {
            'title': 'Sumas',
            'celda': 'totalSumas',
            'content': 'suma:table-total'
        },
        'grabadas': {
            'title': 'Ventas grabadas',
            'celda': 'totalGrabadas',
            'content': 'suma:table-totalg'
        },
        'descuentos': {
            'title': 'Descuentos',
            'celda': 'totalDescuentos',
            'content': 'descuentos:table-descuento'
        },
        'iva': {
            'title': '13 % de IVA',
            'celda': 'totalIVA',
            'content': 'operation:.totalGrabadas|*|0.13'
        },
        'percepcion': {
            'title': '(+) IVA percibido',
            'celda': 'totalIVApercibido',
            'content': 'conditionalOperation:.totalGrabadas@>=@100@.totalGrabadas|*|0.01'
        },
        'retencion': {
            'title': '(-) IVA retenido',
            'celda': 'totalIVAretenido',
            'content': 'conditionalOperation:.totalGrabadas@>=@100@.totalGrabadas|*|0.01'
        },
        'retencionFac': {
            'title': '(-) IVA retenido',
            'celda': 'totalIVAretenido',
            'content': 'conditionalOperation:.totalGrabadas@>=@113@|(|.totalGrabadas|/|1.13|)||*|0.01'
        },
        'subtotal': {
            'title': 'Sub-total',
            'celda': 'totalSubtotal',
            'content': 'operation:.totalGrabadas|+|.totalIVA'
        },
        'nosujetas': {
            'title': 'Ventas No Sujetas',
            'celda': 'totalNS',
            'content': 'suma:table-totalns'
        },
        'exentas': {
            'title': 'Ventas Exentas',
            'celda': 'totalExento',
            'content': 'suma:table-totale'
        },
        'total': {
            'title': '<strong>TOTAL</strong>',
            'celda': 'totalTotal',
            'content': ''
        }
    }
    this.totalsProfile = '';
    this.setBaseUrl = function(url) {
        this.baseUrl = url;
        console.log("La clase URL: " + this.baseUrl + " se ha establecido como base del script");
    }
    this.setProductFrame = function($frame) {
        this.ProductFrame = $frame;
    }
    this.setProductTable = function($table) {
        this.ProductTable = $table;
    }
    this.setTotalTable = function($table) {
        this.totalTable = $table;
    }
    this.SetTotalsProfile = function(profile, totalOp, construc) {
        this.totalsProfile = profile;
        this.Totals['total']['content'] = 'linealOperation:' + totalOp;
        if (construc && this.totalTable) {
            /*Construir tabla de totales!*/
            var _this = this;
            var tablehtml = "";
            var perfil = profile.split(',');
            this.totalTable.find("tbody tr").remove();
            $.each(perfil, function(i, imp) {
                var row = _this.Totals[imp];
                trhtml = "<tr class='" + row.celda + "' data-content='" + row.content + "'>";
                trhtml += "<td>" + row.title + "</td>";
                trhtml += "<td>$</td>";
                trhtml += "<td class='totalval' data-value='0.00'>0.00</td>";
                trhtml += "</tr>";

                _this.totalTable.find("tbody").append(trhtml);

            });
            this.calcTotals();
        } else {
            console.log('totalTable is undefined');
        }
    }
    this.setAjustTotalFrame = function($frame){
        this.AjustTotalFrame = $frame;
    }
    this.test = function() {
        console.log(this.baseURL);
    }
    this.getProductInfoBySKU = function(fields, sku, $focus,$focusElse) {
        if (this.ProductFrame) {
            this.ProductFrame.find(".frame-producto-id").val('');
            this.ProductFrame.find(".frame-producto-ref").val('');
            this.ProductFrame.find(".frame-presentacion-id").val('');
            this.ProductFrame.find(".frame-producto-tipo").val('');
            this.ProductFrame.find(".frame-unidades-representativas").val('');
            this.ProductFrame.find(".frame-producto-existencias").val('');
            this.ProductFrame.find(".frame-producto-tipoventa").val('');
            this.ProductFrame.find(".frame-producto-interno").val('');
            this.ProductFrame.find(".frame-producto-desc").val('');
            this.ProductFrame.find(".frame-producto-precios").val('');
            this.ProductFrame.find(".frame-producto-precio").val('');
            this.ProductFrame.find(".frame-producto-precio-bajo").val('');
            this.ProductFrame.find('.frame-producto-price-indicator').text('');
            this.ProductFrame.find('.frame-producto-cant').val('');
            this.ProductFrame.find('.frame-producto-costo-promedio').val('');
            this.ProductFrame.find('.frame-producto-costo-ultimo').val('');
            var _this = this;
            $.get(this.baseURL + 'productos/producto_info', { fields: fields, conditional: 'sku_presentacion', value: sku }, function(producto) {
                if (producto) {
                    $.each(producto[0], function(fieldName, fieldValue) {
                        switch (fieldName) {
                            case 'sku':
                                { _this.ProductFrame.find('.frame-producto-sku').val(fieldValue); }
                                break;
                            case 'producto':
                                { _this.ProductFrame.find('.frame-producto-id').val(fieldValue); }
                                break;
                            case 'referencia':
                                { _this.ProductFrame.find('.frame-producto-ref').val(fieldValue); }
                                break;
                            case 'presentacion':
                                { _this.ProductFrame.find('.frame-presentacion-id').val(fieldValue); }
                                break;
                            case 'tipo_producto':
                                { _this.ProductFrame.find('.frame-producto-tipo').val(fieldValue); }
                                break;
                            case 'unidades':
                                { _this.ProductFrame.find('.frame-unidades-representativas').val(fieldValue); }
                                break;
                            case 'existencias':
                                { _this.ProductFrame.find('.frame-producto-existencias').val(fieldValue); }
                                break;
                            case 'tipo_venta':
                                { _this.ProductFrame.find('.frame-producto-tipoventa').val(fieldValue); }
                                break;
                            case 'descripcion':
                                { _this.ProductFrame.find('.frame-producto-desc').val(fieldValue); }
                                break;
                            case 'interno':
                                { _this.ProductFrame.find('.frame-producto-interno').val(fieldValue); }
                                break;
                            case 'costo_promedio':
                                { _this.ProductFrame.find('.frame-producto-costo-promedio').val(fieldValue); }
                                break;
                            case 'costo_ultimo':
                                { _this.ProductFrame.find('.frame-producto-costo-ultimo').val(fieldValue); }
                                break;
                            case 'precios':
                                {
                                    _this.ProductFrame.find('.frame-producto-precios').val('');
                                    var lowerPrice = 0;
                                    $.each(fieldValue, function(index, precio) {
                                        if (precio.precio) {
                                            if (index == 0) {
                                                _this.ProductFrame.find('.frame-producto-precio').val(precio.precio);
                                                _this.ProductFrame.find('.frame-producto-price-indicator').text('(precio 1)');
                                                lowerPrice = precio.precio;
                                            }
                                            var preciosStr = _this.ProductFrame.find('.frame-producto-precios').val();
                                            preciosStr += precio.precio + "|" + precio.porcentaje + "*";
                                            _this.ProductFrame.find('.frame-producto-precios').val(preciosStr);
                                            _this.ProductFrame.find('.frame-producto-precio').attr('data-active-price', 0);
                                            if (parseFloat(precio.precio) > 0) {
                                                if (parseFloat(precio.precio) < parseFloat(lowerPrice)) {
                                                    lowerPrice = precio.precio;
                                                }
                                            }
                                        }
                                    });
                                    if (_this.ProductFrame.find('.frame-producto-precios').val() != "") {
                                        preciosStr = _this.ProductFrame.find('.frame-producto-precios').val();
                                        _this.ProductFrame.find('.frame-producto-precios').val(preciosStr.slice(0, -1));
                                    } else {
                                        _this.ProductFrame.find('.frame-producto-precios').val('-');
                                    }
                                    _this.ProductFrame.find('.frame-producto-precio-bajo').val(lowerPrice);
                                }
                                break;
                        }
                    });
                    setTimeout(function(){$focus.focus();},100);
                }else{
					setTimeout(function(){$focusElse.focus();},100);
				}
            }, 'json');
        } else {
            console.log('ProductFrame is undefined');
        }
    }
    this.pricesNavigation = function(action) {
        if (this.ProductFrame.find('.frame-producto-id').val() != '') {
            var $price = this.ProductFrame.find(".frame-producto-precio");
            var activo = $price.attr('data-active-price');
            var pricesList = this.ProductFrame.find('.frame-producto-precios').val();
            pricesList = pricesList.split('*');
            var indexPrice = 0;
            if (action == 'previus') {
                if (activo == '0') {
                    indexPrice = pricesList.length - 1;
                } else {
                    indexPrice = activo - 1;
                }
            } else if (action == 'next') {
                if (activo == pricesList.length - 1) {
                    indexPrice = 0;
                } else {
                    indexPrice = parseInt(activo) + 1;
                }
            }
            $price.val(pricesList[indexPrice].split('|')[0]);
            $price.attr('data-active-price', indexPrice);
            $('.frame-producto-price-indicator').text('(precio ' + (indexPrice + 1) + ')');
        }
    }
    this.addProductToTable = function(schema) {
        if (this.ProductTable && this.ProductFrame) {
            var framesControls = this.ProductFrame.find(".frame-control");
            var validFramesControls = true;
            framesControls.each(function() {
                var val = $.trim($(this).val());
                if (val == "") {
                    validFramesControls = false;
                    $(this).focus();
                } else {
                    if ($(this).attr('data-valid-type') == 'number' && isNaN(val)) {
                        validFramesControls = false;
                        $(this).focus();
                    }
                }
                //console.log($(this).attr('id')+validFramesControls);
                return validFramesControls;
            });
            if (validFramesControls) {
                var fields = schema.split(",");
                var _this = this;
                var productotd = "";
                var productohtml = "";
                var productodata = "";
                $.each(fields, function(i, field) {
                    var action = field.split(":");
                    switch (action[0]) {
                        case 'data':
                            {
                                var elements = action[1].split('@');
                                productodata += " " + elements[1] + "='" + _this.ProductFrame.find(elements[0]).val() + "'";
                            }
                            break;
                        case 'field':
                            {
                                var elements = action[1].split('@');
                                productotd += "<td class='" + elements[1] + "' data-value='" + _this.ProductFrame.find(elements[0]).val() + "'>" + _this.ProductFrame.find(elements[0]).val() + "</td>";
                            }
                            break;
                        case 'operation':
                            {
                                var elements = action[1].split('@');
                                var operators = elements[0].split('|');
                                var operation = "";
                                var operationRslt = 0;
                                $.each(operators, function(i, el) {
                                    if (i % 2 == 0) {
                                        var operator = '';
                                        if (isNaN(el)) { operator = _this.ProductFrame.find(el).val(); } else { operator = el }
                                        operation += operator;
                                    } else {
                                        operation += el;
                                    }
                                });
                                operationRslt = eval(operation);
                                productotd += "<td class='" + elements[1] + "' data-value='" + operationRslt.toFixed(3) + "'>" + operationRslt.toFixed(3) + "</td>";
                            }
                            break;
                        case 'translation':
                            {
                                var elements = action[1].split('@');
                                var trans = _this.ProductFrame.find(elements[0]).val();
                                if (trans == '0')
                                    productotd += "<td class='" + elements[1] + "' data-value='" + trans + "'>G</td>";
                                else if (trans == '1')
                                    productotd += "<td class='" + elements[1] + "' data-value='" + trans + "'>E</td>";
                                else if (trans == '2')
                                    productotd += "<td class='" + elements[1] + "' data-value='" + trans + "'>NS</td>";
                                else if (trans == '3')
                                    productotd += "<td class='" + elements[1] + "' data-value='" + trans + "'>E</td>";
                            }
                            break;
                        case 'command':
                            {
                                var elements = action[1].split('@');
                                productotd += "<td class='" + elements[1] + "'><button type='button' class='btn btn-danger btn-xs btn-rounded'><i class='fa fa-times'></i></button></td>";
                            }
                            break;
                    }
                });
                /** */
                this.ProductTable.find("tr.miracle-selected-table-item").removeClass("miracle-selected-table-item");
                productohtml+="<tr class='miracle-selected-table-item' "+productodata+">"+productotd+"</tr>"

                this.ProductTable.find("tbody").append(productohtml);
                this.calcTotals();

                framesControls.each(function() {
                    if ($(this).attr('id') == "nueva-venta-producto-descuento") {
                        $(this).val('0');
                    } else {
                        $(this).val('');
                    }
                });
                this.ProductFrame.find('.frame-producto-price-indicator').text('');

                setTimeout(function() { framesControls.filter(':first').focus(); }, 100);
            }
        } else {
            console.log('ProductTable or  ProductFrame is undefined');
        }
    }
    this.removeProductToTable = function($row) {
        $row.remove();
        this.calcTotals();
    }
    this.updateTable = function(stmt, resetTotals) {
        var statements = stmt.split(',');
        var _this = this;
        $.each(statements, function(i, statement) {
            var elements = statement.split('@');
            var field = elements[0];
            var action = elements[1].split(':');
            var condition = (typeof elements[2] != 'undefined') ? elements[2].split(':') : null;
            switch (action[0]) {
                case 'operation':
                    {
                        $.each(_this.ProductTable.find('tbody tr'), function(i, row) {
                            var aplicableField = true;
                            if (condition) {
                                conditionElement = condition[1].split('|');
                                var attr = conditionElement[0];
                                var attrValue = conditionElement[2]
                                var conditionOperator = conditionElement[1];
                                switch (conditionOperator) {
                                    case "=":
                                        aplicableField = ($(row).find(condition[0]).attr(attr) == attrValue) ? true : false;
                                        break
                                    case "!=":
                                        aplicableField = ($(row).find(condition[0]).attr(attr) != attrValue) ? true : false;
                                        break
                                    case ">":
                                        aplicableField = ($(row).find(condition[0]).attr(attr) > attrValue) ? true : false;
                                        break
                                    case "<":
                                        aplicableField = ($(row).find(condition[0]).attr(attr) < attrValue) ? true : false;
                                        break
                                    case ">=":
                                        aplicableField = ($(row).find(condition[0]).attr(attr) >= attrValue) ? true : false;
                                        break
                                    case "<=":
                                        aplicableField = ($(row).find(condition[0]).attr(attr) <= attrValue) ? true : false;
                                        break
                                }
                            }
                            if (aplicableField) {
                                var $intervenedField = $(row).find(field);
                                var operators = action[1].split('|');
                                var operation = "";
                                var operationRslt = 0;
                                $.each(operators, function(i, el) {
                                    if (i % 2 == 0) {
                                        var operator = '';
                                        if (isNaN(el)) { operator = $(row).find(el).attr('data-value'); } else { operator = el }
                                        operation += operator;
                                    } else {
                                        operation += el;
                                    }
                                });
                                operationRslt = eval(operation);
                                $intervenedField.attr('data-value', operationRslt.toFixed(3));
                                $intervenedField.text(operationRslt.toFixed(3));
                            }
                        });
                    }
                    break;
                case 'replacewtrans':
                    { /*Replace witch translation*/
                        $.each(_this.ProductTable.find('tbody tr'), function(i, row) {
                            var aplicableField = true;
                            if (condition) {
                                conditionElement = condition[1].split('|');
                                var attr = conditionElement[0];
                                var attrValue = conditionElement[2]
                                var conditionOperator = conditionElement[1];
                                switch (conditionOperator) {
                                    case "=":
                                        aplicableField = ($(row).find(condition[0]).attr(attr) == attrValue) ? true : false;
                                        break
                                    case "!=":
                                        aplicableField = ($(row).find(condition[0]).attr(attr) != attrValue) ? true : false;
                                        break
                                    case ">":
                                        aplicableField = ($(row).find(condition[0]).attr(attr) > attrValue) ? true : false;
                                        break
                                    case "<":
                                        aplicableField = ($(row).find(condition[0]).attr(attr) < attrValue) ? true : false;
                                        break
                                    case ">=":
                                        aplicableField = ($(row).find(condition[0]).attr(attr) >= attrValue) ? true : false;
                                        break
                                    case "<=":
                                        aplicableField = ($(row).find(condition[0]).attr(attr) <= attrValue) ? true : false;
                                        break
                                }
                            }
                            if (aplicableField) {
                                var $intervenedField = $(row).find(field);
                                var replaceNewVal = action[1];
                                $intervenedField.attr('data-value', replaceNewVal);
                                if (replaceNewVal == '0')
                                    $intervenedField.text('G');
                                else if (replaceNewVal == '1')
                                    $intervenedField.text('E');
                                else if (replaceNewVal == '2')
                                    $intervenedField.text('NS');
                                else if (replaceNewVal == '3')
                                    $intervenedField.text('E');
                            }
                        });
                    }
                    break;
            }
        });
        if (resetTotals)
            this.calcTotals();
    }
    this.calcTotals = function() {
        if (this.totalTable) {
            var _this = this;
            $.each(this.totalTable.find('tbody tr'), function(i, row) {
                $(row).find('td.totalval').attr('data-value', '0');
                $(row).find('td.totalval').text('0');
                var totalRow = $(row);
                var contentRow = totalRow.attr('data-content').split(':');
                switch (contentRow[0]) {
                    case 'suma':
                        {
                            if (contentRow[1] == 'table-total') {
                                var suma = 0;
                                _this.ProductTable.find("tbody tr").each(function(i, row) {
                                    suma += parseFloat($(row).find('td.table-total').attr('data-value'));
                                });
                                $(row).find('td.totalval').text(suma.toFixed(2));
                                $(row).find('td.totalval').attr('data-value', suma.toFixed(2));
                            } else if (contentRow[1] == 'table-totalg') { /*sumas grabadas*/
                                var sumag = 0;
                                _this.ProductTable.find("tbody tr").each(function(i, row) {
                                    var producVTipo = $(row).find('td.table-tipoventa').attr('data-value');
                                    if (producVTipo == '0')
                                        sumag += parseFloat($(row).find('td.table-total').attr('data-value'));
                                });
                                $(row).find('td.totalval').text(sumag.toFixed(2));
                                $(row).find('td.totalval').attr('data-value', sumag.toFixed(2));
                            } else if (contentRow[1] == 'table-totale') { /*sumas exentas*/
                                var sumaex = 0;
                                _this.ProductTable.find("tbody tr").each(function(i, row) {
                                    var producVTipo = $(row).find('td.table-tipoventa').attr('data-value');
                                    if (producVTipo == '1' || producVTipo == '3')
                                        sumaex += parseFloat($(row).find('td.table-total').attr('data-value'));
                                });
                                $(row).find('td.totalval').text(sumaex.toFixed(2));
                                $(row).find('td.totalval').attr('data-value', sumaex.toFixed(2));
                            } else if (contentRow[1] == 'table-totalns') {
                                var sumans = 0;
                                _this.ProductTable.find("tbody tr").each(function(i, row) {
                                    var producVTipo = $(row).find('td.table-tipoventa').attr('data-value');
                                    if (producVTipo == '2')
                                        sumans += parseFloat($(row).find('td.table-total').attr('data-value'));
                                });
                                $(row).find('td.totalval').text(sumans.toFixed(2));
                                $(row).find('td.totalval').attr('data-value', sumans.toFixed(2));
                            }
                        }
                        break;
                    case 'operation':
                        {
                            var operators = contentRow[1].split('|');
                            var operator1, operator2 = null;
                            var operationRslt = 0;
                            if (isNaN(operators[0])) { operator1 = _this.totalTable.find("tbody " + operators[0] + " td.totalval").attr('data-value'); } else { operator1 = operators[0] }
                            if (isNaN(operators[2])) { operator2 = _this.totalTable.find("tbody " + operators[2] + " td.totalval").attr('data-value'); } else { operator2 = operators[2]; }

                            if (operators[1] == '*') {
                                operationRslt = parseFloat(operator1) * parseFloat(operator2);
                            } else if (operators[1] == '+') {
                                operationRslt = parseFloat(operator1) + parseFloat(operator2);
                            }
                            $(row).find('td.totalval').text(operationRslt.toFixed(2));
                            $(row).find('td.totalval').attr('data-value', operationRslt.toFixed(2));
                        }
                        break;
                    case 'descuentos':
                        {
                            if (contentRow[1] == 'table-descuento') {
                                var descuentos = 0;
                                _this.ProductTable.find("tbody tr").each(function(i, row) {
                                    descuentos += parseFloat($(row).find('td.table-descuento').attr('data-value'));
                                });
                                $(row).find('td.totalval').text(descuentos.toFixed(2));
                                $(row).find('td.totalval').attr('data-value', descuentos.toFixed(2));
                            }
                        }
                        break;
                    case 'conditionalOperation':
                        {
                            var conditionalOperators = contentRow[1].split('@');
                            var operator1, operator2 = null;
                            var conditional = conditionalOperators[1];
                            var operation = conditionalOperators[3];
                            var operationRslt = 0;
                            if (isNaN(conditionalOperators[0])) { operator1 = _this.totalTable.find("tbody " + conditionalOperators[0] + " td.totalval").attr('data-value'); } else { operator1 = conditionalOperators[0] }
                            if (isNaN(conditionalOperators[2])) { operator2 = _this.totalTable.find("tbody " + conditionalOperators[2] + " td.totalval").attr('data-value'); } else { operator2 = conditionalOperators[2] }
                            if (conditional == '>=') {
                                if (parseFloat(operator1) >= parseFloat(operator2)) {
                                    var operators = operation.split('|');
                                    var operationStr = "";
                                    $.each(operators, function(i, el) {
                                        if (i % 2 == 0) {
                                            var operator = '';
                                            if (isNaN(el)) { operator = _this.totalTable.find("tbody " + el + " td.totalval").attr('data-value'); } else { operator = el }
                                            operationStr += operator;
                                        } else {
                                            operationStr += el;
                                        }
                                    });
                                    //console.log(operationStr);
                                    operationRslt = eval(operationStr);
                                    $(row).find('td.totalval').text(operationRslt.toFixed(2));
                                    $(row).find('td.totalval').attr('data-value', operationRslt.toFixed(2));
                                }
                            }
                        }
                        break;
                    case 'linealOperation':
                        {
                            var opElements = contentRow[1].split('|');
                            var operationRslt = 0;
                            var operation = "";
                            $.each(opElements, function(i, el) {
                                if (i % 2 == 0) {
                                    operation += _this.totalTable.find("tbody " + 'tr.' + _this.Totals[el]['celda'] + " td.totalval").attr('data-value');
                                } else {
                                    operation += el;
                                }
                            });
                            operationRslt = eval(operation);
                            $(row).find('td.totalval').text(operationRslt.toFixed(2));
                            $(row).find('td.totalval').attr('data-value', operationRslt.toFixed(2));
                        }
                        break;
                }
            });
            $(".transacction-item-counter b").text(this.ProductTable.find("tbody tr").size());
            if($(".transacction-item-counter b").text() > 15){
				$("#nueva-venta-limite-msg").show();
			}else{
				$("#nueva-venta-limite-msg").hide();
			}
            /** */
            this.calcAjustTotal();
        } else {
            console.log('totalTable is undefined');
        }
    }
    this.calcAjustTotal =function(){
        if(this.AjustTotalFrame){
           let percent = this.AjustTotalFrame.find("#nueva-venta-fact-ajuste-percent").val();
           percent = (percent != "" && !isNaN(percent) ? parseFloat(percent) / 100 : 1);
           let total = parseFloat(this.totalTable.find("tr.totalTotal > td.totalval").attr("data-value"));
           let newTotal = total * percent;
           this.AjustTotalFrame.find("#nueva-venta-fact-ajuste-total").html("<b>TOTAL: $ "+newTotal.toFixed(2))+"</b>";
        }
        else{
            console.log('Ajust total Billing is undefined');
        }
    }
}