var Ventas=function(){
	this.baseUrl=null;
	this.config=null;
	this.setUrl=function(url){
		this.baseUrl=url;
	},
	this.setConfig=function(conf){
		this.config=conf;
	},
	this.validador={
		productos:function(){
			return {
				result:$("#nueva-venta-productos-wrapper table tr").size()>0,
				msg:"Por favor agregue productos a la lista",
				type:1,
				action:function(){
					$("#nueva-venta-producto-sku").focus();
				}
			}
		},
		existencias:function(){
			return {
				result:($("#nueva-venta-existencias-ok").val()==0?false:true),
				msg:"Existencias insuficientes en algunos productos.",
				type:1,
				action:function(){
					$("#nueva-venta-producto-sku").focus();
				}
			}
		},
		documentosAcobro:function(){
			return {
				result:($("#nueva-venta-documento").val()==1 || $("#nueva-venta-documento").val()==2?true:false),
				msg:"Los documento transitorios no estan permitidos para ventas a cobro, por favor seleccione otro tipo de documento",
				type:1,
				action:function(){
					$("#nueva-venta-documento").focus();
				}
			}
		},
		documentosTransitorioCredito:function(){
			return {
				result:($("#nueva-venta-documento").val()==1 || $("#nueva-venta-documento").val()==2 || $("#nueva-venta-documento").val()==3?true:false),
				msg:"Los documento transitorios estan permitidos solo para ventas al cr&eacute;dito, por favor seleccione otro tipo de documento",
				type:1,
				action:function(){
					$("#nueva-venta-documento").focus();
				}
			}
		},
		documentosFacturadosContado:function(){
			return {
				result:($("#nueva-venta-documento").val()!=1 && $("#nueva-venta-documento").val()!=2 && $("#nueva-venta-documento").val()!=3?true:false),
				msg:"Los documento de facturacion definitiva estan permitidos solo para ventas al contado, por favor seleccione otro tipo de documento",
				type:1,
				action:function(){
					$("#nueva-venta-documento").focus();
				}
			}
		},
		numeroDocumento:function(){
			return {
				result:($.trim($("#nueva-venta-documento-numero").val())!=''?true:false),
				msg:"Por favor ingrese el n&uacute;mero de documento",
				type:1,
				action:function(){
					$("#nueva-venta-documento-numero").focus();
				}
			}
		},
		cliente:function(){
			return {
				result:($.trim($("#nueva-venta-cliente").val())!=''?true:false),
				msg:"Por favor seleccione un cliente",
				type:1,
				action:function(){
					$("#nueva-venta-cliente-buscar-btn").focus();
				}
			}
		},
		clienteNombre:function(){
			return {
				result:($.trim($("#nueva-venta-cliente-text").val())!=""?true:false),
				msg:"Por favor ingrese un nombre o seleccione un cliente",
				type:1,
				action:function(){
					$("#nueva-venta-cliente-text").focus();
				}
			}
		},
		clienteNRC:function(){
			return {
				result:($.trim($("#nueva-venta-cliente-nrc").val())!=""?true:false),
				msg:"Por favor ingrese el N&uacute;mero de Registro Comercial (NRC)",
				type:2,
				action:function(){
					$('#nueva-venta-cliente-docs').on('shown.bs.modal', function () {
						$("#nueva-venta-cliente-nrc").focus();
					});
					$('#nueva-venta-cliente-docs').modal("show");
					$("#nueva-venta-cliente-nrc").focus();
				}
			}
		},
		clienteDUIoNIT:function(){
			return {
				result:($.trim($("#nueva-venta-cliente-dui").inputmask('unmaskedvalue')).length == 9 || $.trim($("#nueva-venta-cliente-nit").inputmask('unmaskedvalue')).length == 14?true:false),
				msg:"Por favor ingrese el N&uacute;mero de Documento Unico de Identidad (DUI) 0 el N&uacute;mero de Identificaci&oacute;n tributaria (NIT) v&aacute;lido",
				type:2,
				action:function(){
					$('#nueva-venta-cliente-docs').on('shown.bs.modal', function () {
						$("#nueva-venta-cliente-dui").focus();
					});
					$('#nueva-venta-cliente-docs').modal("show");
					$("#nueva-venta-cliente-dui").focus();
				}
			}
		},
		creditoAutorizado:function(){
			return {
				result:($("#nueva-venta-cliente-text").attr('data-credito')=='1'?true:false),
				msg:"El cliente seleccionado no posee cr&eacute;ditos autorizados",
				type:1
			}
		},
		creditoMontoAutorizado:function(){
			var disponible=0;
			jQuery.ajaxSetup({async:false});
			$.get(window.location.protocol+"//"+window.location.host+"/"+window.location.pathname.split('/')[1]+'/clientes/getcreditodisponible',{cliente:$.trim($("#nueva-venta-cliente").val())},function(disp){
				disponible=parseFloat(disp);
			},'text');
			jQuery.ajaxSetup({async:true});
			return {
				result:(parseFloat($('#nueva-venta-totales-wrapper .totalval').attr('data-value')) <= disponible?true:false),
				msg:"El monto de esta transacci&oacute;n supera el cr&eacute;dito disponible para el cliente seleccionado",
				type:1
			}
		},
		credito:function(){
			return {
				result:($.trim($("#credito-venta").val())!=''?true:false),
				type:3,
				action:function(){
					if(!($("#nueva-venta-credito").data('bs.modal') || {}).isShown){
					var date = new Date();					
						$('#credito-fecha-limite-wrapper .input-group.date').datepicker('setDate', new Date(date.setTime( date.getTime()+30*86400000)));
						$('#credito-fecha-limite-wrapper .input-group.date').datepicker('update');
						$('#credito-fecha-limite-wrapper .input-group.date').val('');
						$('#credito-fecha-limite-wrapper').css('display','block');
						$('#creditos-cliente-list').css('display','none');
						$('#crediaccion-nuevo').prop('checked','checked');
						$("#nueva-venta-credito").modal("show");
						$('#nueva-venta-credito').on('shown.bs.modal', function () {
							$('.crediaccion input:radio').iCheck('update');
							$("#nueva-venta-credito-guardar-btn").focus();
						});
					}
				}
			}
		},
		fechacredito:function(){
			return {
				result:($.trim($("#credito-fecha-limite").val())!=''?true:false),
				type:3,
				msg:'Por favor ingrese una fecha de finalizaci&oacute;n de cr&eacute;dito v&aacute;lida.',
				action:function(){
					$("#credito-fecha-limite").focus();
				}
			}
		},
		formaPago:function(){
			return {
				result:($.trim($("#forma-pago").val())!=''?true:false),
				type:4,
				action:function(){
					if($("#nueva-venta-documento").val()==3 || $("#nueva-venta-documento").val()==1 || $("#nueva-venta-documento").val()==2){
						$("#nueva-venta-impresion-frame").show();
						//$("#nueva-venta-impresion-frame").hide();
					}else{
						$("#nueva-venta-impresion-frame").hide();
					}
					$("#nueva-venta-forma-pago-total").text("$"+parseFloat($('#nueva-venta-totales-wrapper .totalTotal .totalval').attr('data-value')));
					$('#nueva-venta-forma-pago').on('shown.bs.modal',function(){
						$("#nueva-venta-forma-pago-efectivo").focus();
					});
					$('#nueva-venta-forma-pago').modal("show");
					//$("#nueva-venta-forma-pago-efectivo").focus().val(parseFloat($('#nueva-venta-totales-wrapper .totalTotal .totalval').attr('data-value'))).trigger("keyup");
					$("#nueva-venta-forma-pago-efectivo").focus();
				}
			}
		},
		formaPagoEfectivo:function(){
			return {
				result:($.trim($("#efectivo-venta").val())!=''?true:false),
				type:4,
				msg:"por favor ingrese la cantidad de efectivo para esta venta",
				action:function(){
					$("#nueva-venta-forma-pago-efectivo").focus();
				}
			}
		},
		formaPagoEfectivoMixto:function(){
			return {
				result:($.trim($("#efectivo-venta").val())!=''?true:false),
				type:4,
				msg:"por favor ingrese la cantidad de efectivo para esta venta",
				action:function(){
					$("#nueva-venta-forma-pago-efectivo-mixto").focus();
				}
			}
		},
		formaPagoPosMixto:function(){
			return {
				result:($.trim($("#pos-venta").val())!=''?true:false),
				type:4,
				msg:"por favor ingrese la cantidad de pos para esta venta",
				action:function(){
					$("#nueva-venta-forma-pago-pos-mixto").focus();
				}
			}
		},
		formaPagoEfectivoValido:function(){
			return {
				result:($.trim($("#efectivo-venta").val())>=parseFloat($('#nueva-venta-totales-wrapper .totalTotal .totalval').attr('data-value'))?true:false),
				type:4,
				msg:"El efectivo no puede ser menor que el total de la venta, por favor verifique.",
				action:function(){
					$("#nueva-venta-forma-pago-efectivo").select();
				}
			}
		},
		formaPagoEfectivoMixtoValido:function(){
			return {
				result:($.trim($("#efectivo-venta").val())>=(parseFloat($('#nueva-venta-totales-wrapper .totalTotal .totalval').attr('data-value')) - parseFloat($('#pos-venta').val()))?true:false),
				type:4,
				msg:"El efectivo mixto no puede ser menor que el total de la venta, por favor verifique.",
				action:function(){
					$("#nueva-venta-forma-pago-efectivo-mixto").select();
				}
			}
		},
		formaPagoPosMixtoValido:function(){
			return {
				result:($.trim($("#pos-venta").val())>=(parseFloat($('#nueva-venta-totales-wrapper .totalTotal .totalval').attr('data-value')) - parseFloat($('#efectivo-venta').val()))?true:false),
				type:4,
				msg:"El pos no puede ser menor que el total de la venta, por favor verifique.",
				action:function(){
					$("#nueva-venta-forma-pago-pos-mixto").select();
				}
			}
		}
	}
	this.test=function(){
		console.log('La clase Ventas ha sido instanciado correctamente');
	}
	this.validarVenta=function($sender){
		if($sender){
			$sender.attr('disabled','disabled');
		}
		var _this=this;
		var reglas={productos:this.validador.productos()};
		var reglasTipo1=1;
		var reglasTipo2=0;
		var reglasTipo3=0;
		var reglasTipo4=0;
		/*Existencias*/
		reglas.existencias=this.validador.existencias();
		reglasTipo1+=1;
		/*Nombre del cliente*/
		if(this.config.transacciones_validar_cliente){
			reglas.clienteNombre=this.validador.clienteNombre();
			reglasTipo1+=1;
		}		
		/*Contado en documento transitorios*/
		if($("#nueva-venta-condicion").val()==0 && this.config.transacciones_validar_credito_transitorios){
			reglas.documentosTransitorioCredito=this.validador.documentosTransitorioCredito();
			reglasTipo1+=1;
		}		
		/*Contado en documento transitorios*/
		if($("#nueva-venta-condicion").val()==1 && this.config.transacciones_validar_contado_facturados){
			reglas.documentosFacturadosContado=this.validador.documentosFacturadosContado();
			reglasTipo1+=1;
		}
		/*Documentos distintos a ninguno*/
		if($("#nueva-venta-documento").val()!=0){
			reglas.numeroDocumento=this.validador.numeroDocumento();
			reglasTipo1+=1;
		}
		/*Venta credito nivel 1*/
		if($("#nueva-venta-condicion").val()==1){
			reglas.cliente=this.validador.cliente();
			reglas.creditoAutorizado=this.validador.creditoAutorizado();
			reglas.creditoMontoAutorizado=this.validador.creditoMontoAutorizado();
			delete reglas.clienteNombre;
			reglasTipo1+=2;
		}
		/*Venta a cobro nivel 1*/
		if($("#nueva-venta-condicion").val()==3){
			reglas.cliente=this.validador.cliente();
			reglas.documentosAcobro=this.validador.documentosAcobro();
			delete reglas.clienteNombre;
			reglasTipo1+=2;
		}		
		/*Venta con CCF*/
		if($("#nueva-venta-documento").val()==2){
			reglas.clienteNRC=this.validador.clienteNRC();
			reglasTipo2+=1;
		}
		/*Venta mayor a 200 Factura*/
		if(parseFloat($('#nueva-venta-totales-wrapper .totalTotal .totalval').attr('data-value'))>=200.00 && $("#nueva-venta-documento").val()==1){
			if(!this.config.transacciones_validar_cliente){
				reglas.clienteNombre=this.validador.clienteNombre();
				reglasTipo1+=1;
			}
			reglas.clienteDUI=this.validador.clienteDUIoNIT();
			reglasTipo2+=1;
		}
		/*Venta mayor a 200 Ticket*/
		if(parseFloat($('#nueva-venta-totales-wrapper .totalTotal .totalval').attr('data-value'))>=200.00 && $("#nueva-venta-documento").val()==3){
			reglas.clienteDUI=this.validador.clienteDUIoNIT();
			reglasTipo2+=1;
		}
		/*Venta credito nivel 3*/
		if($("#nueva-venta-condicion").val()==1){
			reglas.credito=this.validador.credito();
			reglasTipo3+=1;
			if($('#crediaccion-nuevo').is(':checked')){
				reglas.fechacredito=this.validador.fechacredito();
				reglasTipo3+=1;
			}
		}
		/*Medio de pago p/ventas al contado*/
		if($("#nueva-venta-condicion").val()==0){
			reglas.formaPago=this.validador.formaPago();
			reglasTipo4+=1;
			if(parseInt($("#forma-pago").val())==1){
				reglas.formaPagoEfectivo=this.validador.formaPagoEfectivo();
				reglas.formaPagoEfectivoValido=this.validador.formaPagoEfectivoValido();
				reglasTipo4+=2;
			}else if($("#forma-pago").val()==6){
				reglas.formaPagoEfectivoMixto=this.validador.formaPagoEfectivoMixto();
				reglas.formaPagoPosMixto=this.validador.formaPagoPosMixto();
				reglas.formaPagoEfectivoMixtoValido=this.validador.formaPagoEfectivoMixtoValido();
				reglas.formaPagoPosMixtoValido=this.validador.formaPagoPosMixtoValido();
				reglasTipo4+=4;
			}
		}
		var valid=true;
		var reglasCountTipo1=0;
		var reglasCountTipo2=0;
		var reglasCountTipo3=0;
		var reglasCountTipo4=0;
		var errorInType=null;
		$.each(reglas,function(i,regla){
			if(regla.type){
				if(regla.type==1)
					reglasCountTipo1+=1;
				else if(regla.type==2)
					reglasCountTipo2+=1;
				else if(regla.type==3)
					reglasCountTipo3+=1;
				else if(regla.type==4)
					reglasCountTipo4+=1;
			}
			if(!regla.result){
				valid=regla.result;
				if(regla.msg)
					_this.showMsgVenta('error',regla.msg);
				if(regla.action)
					regla.action();
				if(regla.type)
					errorInType=regla.type;
			}else{
				if(reglasCountTipo2==reglasTipo2)
					$('#nueva-venta-cliente-docs').modal("hide");
				if(reglasCountTipo3==reglasTipo3)
					$('#nueva-venta-credito').modal("hide");	
				if(reglasCountTipo4==reglasTipo4)
					$('#nueva-venta-forma-pago').modal("hide");	
			}
			return valid;
		});
		if(valid){
			$("#nueva-venta-confirm-total").text(parseFloat($('#nueva-venta-totales-wrapper .totalTotal .totalval').attr('data-value')));
			if($.trim($("#forma-pago").val())==1){
				$("#nueva-venta-confirm-efectivo").text(parseFloat($("#efectivo-venta").val()).toFixed(2));
				$("#nueva-venta-confirm-pos").text("N/A");
				$("#nueva-venta-confirm-cambio").text(parseFloat($("#cambio-venta").val()).toFixed(2));
				$(".nueva-venta-confirm-efectivo-table").show();
			}else if($.trim($("#forma-pago").val())==6){
				$("#nueva-venta-confirm-efectivo").text(parseFloat($("#efectivo-venta").val()).toFixed(2));
				$("#nueva-venta-confirm-pos").text(parseFloat($("#pos-venta").val()).toFixed(2));
				$("#nueva-venta-confirm-cambio").text(parseFloat($("#cambio-venta").val()).toFixed(2));
				$(".nueva-venta-confirm-efectivo-table").show();
			}else{
				$(".nueva-venta-confirm-efectivo-table").hide();
			}
			$('#nueva-venta-confirmar').on('shown.bs.modal', function () {
				$("#nueva-venta-confirmar-guardar-btn").focus();
				$("#guardar-venta-btn").attr('disabled','disabled');
			});
			$("#nueva-venta-confirmar").modal({backdrop: 'static', keyboard: false});
			$("#nueva-venta-confirmar").modal("show");
		}
		else{
			if(errorInType==1)
				$("#guardar-venta-btn").removeAttr('disabled');
			else if(errorInType==2)
				$("#nueva-venta-doc-guardar-btn").removeAttr('disabled');
			else if(errorInType==3)
				$("#nueva-venta-credito-guardar-btn").removeAttr('disabled');
			else if(errorInType==4)
				$("#nueva-venta-fpago-guardar-btn").removeAttr('disabled');
		}
	}
	this.cancelarValidarVenta=function(modal){
		$("#guardar-venta-btn").removeAttr('disabled');
		$("#nueva-venta-doc-guardar-btn").removeAttr('disabled');
		$("#nueva-venta-fpago-guardar-btn").removeAttr('disabled');
		$("#nueva-venta-confirmar-guardar-btn").removeAttr('disabled');
		$("#nueva-venta-cancelar-guardar-btn").removeAttr('disabled');	
		$("#nueva-venta-forma-pago-efectivo").val('');
		$("#nueva-venta-forma-pago-cambio").val('');
		if(modal==="confirmar"){
			$("#credito-venta").val("");
			$("#ncredito-fecha-limite").val("");
			$("#ncredito-dias").val("");
			$("#forma-pago").val("");
			$("#efectivo-venta").val('');
		}
	}
	this.processVenta=function(){
		var _this=this;
		$("#nueva-venta-confirmar-guardar-btn").attr('disabled','disabled');
		$("#nueva-venta-cancelar-guardar-btn").attr('disabled','disabled');
		$("#nueva-venta-procesar-status-text").text('Guardando venta...');
		$("#nueva-venta-procesar-status-icon").html("<i class='fa fa-spinner fa-5x'></i>");
		var productos=[];
		var totales=[];
		var products=$("#nueva-venta-productos-wrapper table tr");
		var totals=$("#nueva-venta-totales-wrapper tr");
		$.each(products,function(index,product){
			productos.push({descarga:true,id:$(product).attr('data-id'),ref:$(product).attr('data-ref'),pre:$(product).attr('data-pre'),tipo:$(product).attr('data-tipo'),interno:$(product).attr('data-interno'),uequiv:$(product).attr('data-uequiv'),desc:$(product).find('.table-desc').attr('data-value'),cant:$(product).find('.table-cant').attr('data-value'),costo:$(product).find('.table-precio').attr('data-value'),descuento:$(product).find('.table-descuento').attr('data-value'),tipoventa:$(product).find('.table-tipoventa').attr('data-value')});
		});
		$.each(totals,function(index,total){
			switch($(total).attr('class')){
				case 'totalSumas':totales.push({totalSumas:$(total).find('.totalval').attr('data-value')});break;
				case 'totalGrabadas':totales.push({totalGrabadas:$(total).find('.totalval').attr('data-value')});break;
				case 'totalDescuentos':totales.push({totalDescuentos:$(total).find('.totalval').attr('data-value')});break;
				case 'totalIVA':totales.push({totalIVA:$(total).find('.totalval').attr('data-value')});break;
				case 'totalIVApercibido':totales.push({totalIVApercibido:$(total).find('.totalval').attr('data-value')});break;
				case 'totalIVAretenido':totales.push({totalIVAretenido:$(total).find('.totalval').attr('data-value')});break;
				case 'totalSubtotal':totales.push({totalSubtotal:$(total).find('.totalval').attr('data-value')});break;
				case 'totalNS':totales.push({totalNS:$(total).find('.totalval').attr('data-value')});break;
				case 'totalExento':totales.push({totalExento:$(total).find('.totalval').attr('data-value')});break;
				case 'totalTotal':totales.push({totalTotal:$(total).find('.totalval').attr('data-value')});break;
			}
		});
		var condicion=$('#nueva-venta-condicion').val();
		var credito=$('#credito-venta').val();
		if(condicion==3){
			credito="CREATE";
        }
		let porcentajeFact = $("#nueva-venta-fact-ajuste-percent").val();
		porcentajeFact = (porcentajeFact != "" && !isNaN(porcentajeFact) ? parseFloat(porcentajeFact) / 100 : 1);
        $.ajax({
            url : _this.baseUrl+'transacciones/guardarventa',
            type : 'POST',
            data :  {
                fecha:$('#nueva-venta-fecha').val(),
                cliente:$('#nueva-venta-cliente').val(),
                clientetxt:$.trim($("#nueva-venta-cliente-text").val()),
                dui:$.trim($("#nueva-venta-cliente-dui").val()),
                nit:$.trim($("#nueva-venta-cliente-nit").val()),
                nrc:$.trim($("#nueva-venta-cliente-nrc").val()),
                condicion:condicion,
                documento:$('#nueva-venta-documento').val(),
                serie:$("#nueva-venta-documento-serie").val(),
                serieid:$("#nueva-venta-documento-serie option:selected").attr("data-id"),
                numero:$('#nueva-venta-documento-numero').val(),
                credito:credito,
                fechacred:$('#ncredito-fecha-limite').val(),
                diascred:$('#ncredito-dias').val(),
                efectivo:$('#efectivo-venta').val(),
                pos:$('#pos-venta').val(),
                vendedor:$("#nueva-venta-vendedor-id").val(),
                fpago:$("#forma-pago").val(),
                impresion:$("#nueva-venta-impresion").val(),
                trans:$("#nueva-venta-cargar-text").attr("data-transaccion"),
                transid:$("#nueva-venta-cargar-text").attr("data-id"),
                productos:JSON.stringify(productos),
                totales:JSON.stringify(totales),
				porcfact: porcentajeFact
            },
            retryLimit : 3,
            success : function(dataPrint) {
				//do something
				$("#nueva-venta-procesar-status-text").text('¡La venta se ha guardado!');
				if($('#nueva-venta-condicion').val()==3){
					var statusText=$("#nueva-venta-procesar-status-text").text()+"</br> <span style='font-weight:normal;'>Inserte primero la factura y luego el recibo de cobro en la impresora</span>";
					$("#nueva-venta-procesar-status-text").html(statusText);
				}
				$("#nueva-venta-procesar-status-icon").html("<i style='color:#1AB394;' class='fa fa-check-circle fa-5x'></i>");
				$("#nueva-venta-confirmar-guardar-btn").hide();
				$("#nueva-venta-cancelar-guardar-btn").hide();
				$("#nueva-venta-confirmar-salir-btn").hide();
				$("#nueva-venta-reset-btn").show();
				$("#nueva-venta-reset-btn").focus();
                if(dataPrint){                    
                    var urlLocal="";
                    
                    switch($('#nueva-venta-documento').val()){
                        case "1":
                            urlLocal="http://localhost/miracle_print/factura.php";
                        break;
                        case "2":
                            urlLocal="http://localhost/miracle_print/ccf.php";
                        break;
                        case "3":
                            urlLocal="http://localhost/miracle_print/ticket.php";
                        break;
                        case "5":
                            urlLocal="http://localhost/miracleprint/envio.php";
                        break;
                    }
                    
                    if(urlLocal!=""){
                        $.post(urlLocal,{
                            dataPrint:dataPrint
                        })
                        .done(function(response){                
                            
                        });					
                    }
                }
            },
            error : function(xhr, textStatus, errorThrown ) {
                if (textStatus == 'timeout') {
                    this.tryCount++;
                    if (this.tryCount <= this.retryLimit) {
                        //try again
                        console.log("Paso por aca");
                        $.ajax(this);
                        return;
                    }            
                    return;
                }
                if (xhr.status == 500) {
                    //handle error
                    console.log("Hizo esto");
                } else {
                    //handle error
                    console.log("Hizo esto otro");
                    $("#nueva-venta-procesar-status-icon").html("<i style='color:#23C6C8;' class='fa fa-question-circle fa-5x'></i>");
                    $("#nueva-venta-procesar-status-text").text('&iquest;Desea guardar esta venta?');
                    $("#nueva-venta-confirmar-guardar-btn").removeAttr('disabled').text("Reenviar venta");
		            $("#nueva-venta-cancelar-guardar-btn").removeAttr('disabled');

                }
            }
        });
		/* $.post(_this.baseUrl+'transacciones/guardarventa', {
			cliente:$('#nueva-venta-cliente').val(),
			clientetxt:$.trim($("#nueva-venta-cliente-text").val()),
			dui:$.trim($("#nueva-venta-cliente-dui").val()),
			nit:$.trim($("#nueva-venta-cliente-nit").val()),
			nrc:$.trim($("#nueva-venta-cliente-nrc").val()),
			condicion:condicion,
			documento:$('#nueva-venta-documento').val(),
			serie:$("#nueva-venta-documento-serie").val(),
			serieid:$("#nueva-venta-documento-serie option:selected").attr("data-id"),
			numero:$('#nueva-venta-documento-numero').val(),
			credito:credito,
			fechacred:$('#ncredito-fecha-limite').val(),
			diascred:$('#ncredito-dias').val(),
			efectivo:$('#efectivo-venta').val(),
			vendedor:$("#nueva-venta-vendedor-id").val(),
			fpago:$("#forma-pago").val(),
			impresion:$("#nueva-venta-impresion").val(),
			trans:$("#nueva-venta-cargar-text").attr("data-transaccion"),
			transid:$("#nueva-venta-cargar-text").attr("data-id"),
			productos:JSON.stringify(productos),
			totales:JSON.stringify(totales)})
		.done(function(dataPrint){
			if(dataPrint){
				$("#nueva-venta-procesar-status-text").text('¡La venta se ha guardado!');
				if($('#nueva-venta-condicion').val()==3){
					var statusText=$("#nueva-venta-procesar-status-text").text()+"</br> <span style='font-weight:normal;'>Inserte primero la factura y luego el recibo de cobro en la impresora</span>";
					$("#nueva-venta-procesar-status-text").html(statusText);
				}
				$("#nueva-venta-procesar-status-icon").html("<i style='color:#1AB394;' class='fa fa-check-circle fa-5x'></i>");
				$("#nueva-venta-confirmar-guardar-btn").hide();
				$("#nueva-venta-cancelar-guardar-btn").hide();
				$("#nueva-venta-confirmar-salir-btn").show();
				$("#nueva-venta-reset-btn").show();
				$("#nueva-venta-reset-btn").focus();
				
				var urlLocal="";
				
				switch($('#nueva-venta-documento').val()){
					case "1":
						urlLocal="http://localhost/miracleprint/factura.php";
					break;
					case "2":
						urlLocal="http://localhost/miracleprint/ccf.php";
					break;
					case "3":
						urlLocal="http://localhost/miracleprint/ticket.php";
					break;
					case "5":
						urlLocal="http://localhost/miracleprint/envio.php";
					break;
				}
				
				if(urlLocal!=""){
					$.post(urlLocal,{
						dataPrint:dataPrint
					})
					.done(function(response){                
						
					});					
				}
			}
		}); */		
	}
	this.showMsgVenta=function(tipo, mensaje){
		toastr.options = {
			"closeButton": true,
			"progressBar": true,
			"positionClass": "toast-top-right"
		}
		toastr[tipo](mensaje);
	}
}
var ventas = new Ventas();