var Productos_inventario=function(){
	this.baseUrl=null;
	this.windowId=null;
	this.tableProductos=null;
	this.initializeEnviroment=function(url,winId){
		this.baseUrl=url;
		this.windowId=winId;
		this.initializeListeners();
		this.initializeGUIComponets();
	},
	this.initializeGUIComponets=function(){
		var _this=this;
		/*------------------------------------- DATATABLES PRODUCTOS ------------------------------------*/
		/*Datatable*/
		this.tableProductos=$("#"+this.windowId+" #inventario-productos-tabla").DataTable({
			"order":[1,'asc'],
			"iDisplayLength": 7,
			"aLengthMenu": [[7], [7]],
			"serverSide":true,
			"ajax": {
				"url": _this.baseUrl+"productos/cargar_inventario",
				"type": "POST",
				"data":function(d){
					d.search['estado']=($("#"+_this.windowId+" #productos-buscar-estado").val()!=null?$("#"+_this.windowId+" #productos-buscar-estado").val():1);
				}
			},
			"dom": 'lf<"custom_searchbox_productos">tip',
			"columns":[
				{"name":'sku_presentacion',"data":"sku","width":'20%'},
				{"name":'desc_presentacion',"data":"desc","width":'40%'},
				{"name":'existencia',"data":"existencia","width":'20%',"orderable":false},
				{"name":'estado',"data":"estado","width":'15%',"orderable":false,'className':'text-center'},
				{"name":'stock',"data":"stock","width":'5%',"orderable":false,'className':'text-center'},
			],
			"language":{
				"emptyTable":"",
				"lengthMenu":"Mostrar _MENU_ registros por pagina",
				"zeroRecords":"No se ha encontrado productos",
				"info":"Pagina _PAGE_ de _PAGES_",
				"infoEmpty":"No hay productos",
				"infoFiltered":"",
				"search":"Buscar: ",
				"processing":"<div class='overlay'><i class='fa fa-refresh fa-spin'></i></div>",
				"loadingRecords":"<div class='overlay'><i class='fa fa-refresh fa-spin'></i></div>",
				"paginate":{
					"first":"Primero",
					"last":"Ultimo",
					"next":"Siguiente",
					"previous":"Anterior"
				}
			},
		});
		/*Parametros adicionales de busqueda*/
		var searchParam="<div class='pull-right m-r-sm'>";
		searchParam+="		<label style='font-weight:normal;'>Ver: </label>";
		searchParam+="		<select id='productos-buscar-estado' class='form-control input-sm'>";
		searchParam+="			<option value='1' selected>En stock</option>";
		searchParam+="			<option value='0'>Fuera stock</option>";
		searchParam+="			<option value=''>Todos</option>"
		searchParam+="		</select>";
		searchParam+="	</div>";
		$("div.custom_searchbox_productos").html(searchParam);
		/*Scrollbars*/
		$("#"+this.windowId+" #inventario-productos-tabla-wrapper").slimScroll({height: '550px'});
		$("#"+this.windowId+" #producto-detalles").slimScroll({height: '600px'});
		/** */
		$("#"+this.windowId+" #inventario-reporte-fecha-txt").datepicker({
            language:'es',
			format:'dd-mm-yyyy',
			autoclose:true
        });
	},
	this.initializeListeners=function(){
		var _this=this;
		/*SELECT cambiar estado de busqueda (CHANGE)*/
		$("#"+this.windowId).on("change","#productos-buscar-estado",function(){
			_this.tableProductos.draw();
		});
		/*ROW Ver detalles de un producto (CLICK)*/
		$("#"+this.windowId+" #inventario-productos-tabla").on("click","tbody > tr",function(e){
			var id=$(this).attr("id").split("_")[1];
			$("#"+_this.windowId+" #inventario-productos-tabla .table-selected-item").removeClass("table-selected-item");
			$(this).addClass("table-selected-item");
			/*Cargar detalles*/
			$.get(_this.baseUrl+'productos/ver_producto?id='+id)
			.done(function(producto_detalles){                
				$("#"+_this.windowId+" #producto-detalles").html(producto_detalles);
			});
		});
		/*BUTTON Nuevo producto (CLICK)*/
		$("#"+this.windowId+" #productos-inventario-nuevo-btn").click(function(){
			Custombox.open({
				target:_this.baseUrl+"productos/nuevo_producto", 
				effect: 'fadein',
				complete:function(){
					$(".modal-body input:text").first().focus();
				}
			});
		});
		$("#"+this.windowId+" #productos-inventario-exportar-excel-btn").click(function(){
			window.open(_this.baseUrl+"reportes/reporte_inventario_excel");
		});
		/** Reporte de inventario */
		$("#"+this.windowId+" #producto-inventario-exportar-inventario-cpromedio").click(function(){
			$("#inventario-reporte-fecha-modal").modal("show");
		});
		/**BUTTON Salir de modal de inventario (CLICK) */
		$("#"+this.windowId+" #inventario-reporte-fecha-cancel-btn").click(function(){
			$("#inventario-reporte-fecha-modal").modal("hide");
			$("#inventario-reporte-fecha-txt").val("");
			$("#inventario-reporte-ver-agotados").prop("checked",false);
			$("#inventario-reporte-ver-negativos").prop("checked",false);
		});
		/**BUTTON generar reporte inventario (CLICK) */
		$("#"+this.windowId+" #inventario-reporte-fecha-guardar-btn").click(function(){
			if($("#inventario-reporte-fecha-txt").val() != ""){
				let incAgotados = $("#inventario-reporte-ver-agotados").is(":checked");
				let incNegativos = $("#inventario-reporte-ver-negativos").is(":checked");

				window.open(_this.baseUrl+"auxiliar/reporte_inventario_cp?d="+$("#inventario-reporte-fecha-txt").val()+"&ia="+incAgotados+"&in="+incNegativos);
				$("#inventario-reporte-fecha-modal").modal("hide");
				$("#inventario-reporte-fecha-txt").val("");
			}else{
				_this.showMsg("error","Seleccione una fecha v&aacute;lida");
				$("#inventario-reporte-fecha-txt").focus();
			}
		});
	},
	/*FUNCIONES*/
	this.test=function(){
		console.log("La clase Productos_inventario se ha instanseado desde: "+this.baseUrl, " en la ventana: "+this.windowId);
	}
	/**FUNCION: Mostrar mensaje en pantalla */
	this.showMsg= function(tipo, mensaje){
		toastr.options = {
			"closeButton": true,
			"progressBar": true,
			"positionClass": "toast-top-right"
		}
		toastr[tipo](mensaje);
	}
}